/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.web.flux.response;

import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.cloud.function.context.catalog.FunctionInspector;
import org.springframework.cloud.function.web.flux.constants.WebRequestConstants;
import org.springframework.cloud.function.web.flux.response.FluxResponseBodyEmitter;
import org.springframework.cloud.function.web.flux.response.FluxResponseSseEmitter;
import org.springframework.cloud.function.web.util.HeaderUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.messaging.Message;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.AsyncHandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitter;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyEmitterReturnValueHandler;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FluxReturnValueHandler
implements AsyncHandlerMethodReturnValueHandler {
    private static Log logger = LogFactory.getLog(FluxReturnValueHandler.class);
    private ResponseBodyEmitterReturnValueHandler delegate;
    private RequestResponseBodyMethodProcessor single;
    private long timeout = 1000L;
    private static final MediaType EVENT_STREAM = MediaType.valueOf((String)"text/event-stream");
    private FunctionInspector inspector;
    private MethodParameter singleReturnType;

    public FluxReturnValueHandler(FunctionInspector inspector, List<HttpMessageConverter<?>> messageConverters) {
        this.inspector = inspector;
        this.delegate = new ResponseBodyEmitterReturnValueHandler(messageConverters);
        this.single = new RequestResponseBodyMethodProcessor(messageConverters);
        Method method = ReflectionUtils.findMethod(this.getClass(), (String)"singleValue");
        this.singleReturnType = new MethodParameter(method, -1);
    }

    ResponseEntity<Object> singleValue() {
        return null;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isAsyncReturnValue(Object returnValue, MethodParameter returnType) {
        if (returnValue != null) {
            return this.supportsReturnType(returnType);
        }
        return false;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return returnType.getParameterType() != null && (Publisher.class.isAssignableFrom(returnType.getParameterType()) || this.isResponseEntity(returnType)) || Publisher.class.isAssignableFrom(returnType.getMethod().getReturnType());
    }

    private boolean isResponseEntity(MethodParameter returnType) {
        if (ResponseEntity.class.isAssignableFrom(returnType.getParameterType())) {
            Class bodyType = ResolvableType.forMethodParameter((MethodParameter)returnType).getGeneric(new int[]{0}).resolve();
            return bodyType != null && Publisher.class.isAssignableFrom(bodyType);
        }
        return false;
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Class type;
        if (returnValue == null) {
            mavContainer.setRequestHandled(true);
            return;
        }
        Object adaptFrom = returnValue;
        if (returnValue instanceof ResponseEntity) {
            ResponseEntity value = (ResponseEntity)returnValue;
            adaptFrom = value.getBody();
            HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
            response.setStatus(value.getStatusCodeValue());
            HttpHeaders headers = value.getHeaders();
            for (String name : headers.keySet()) {
                List list = headers.get((Object)name);
                for (String header : list) {
                    response.addHeader(name, header);
                }
            }
        }
        Publisher flux = (Publisher)adaptFrom;
        Object handler = webRequest.getAttribute(WebRequestConstants.HANDLER, 0);
        if (this.isOutputSingle(webRequest, handler, type = this.inspector.getOutputType(handler))) {
            Object result = Flux.from((Publisher)flux).blockFirst();
            if (result instanceof Message) {
                Message message = (Message)result;
                result = message.getPayload();
                this.addHeaders(webRequest, message);
            }
            this.single.handleReturnValue(result, this.singleReturnType, mavContainer, webRequest);
            return;
        }
        MediaType mediaType = null;
        mediaType = this.isPlainText(webRequest) && (CharSequence.class.isAssignableFrom(type) || Void.class.isAssignableFrom(type)) ? MediaType.TEXT_PLAIN : this.findMediaType(webRequest);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Handling return value " + type + " with media type: " + mediaType));
        }
        ServletServerHttpRequest request = new ServletServerHttpRequest((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));
        this.delegate.handleReturnValue((Object)this.getEmitter(this.timeout, flux, mediaType, request.getHeaders()), returnType, mavContainer, webRequest);
    }

    private void addHeaders(NativeWebRequest webRequest, Message<?> message) {
        HttpServletResponse response = (HttpServletResponse)webRequest.getNativeResponse(HttpServletResponse.class);
        ServletServerHttpRequest request = new ServletServerHttpRequest((HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class));
        HttpHeaders headers = HeaderUtils.fromMessage(message.getHeaders(), request.getHeaders());
        for (String name : headers.keySet()) {
            for (Object object : headers.get((Object)name)) {
                response.addHeader(name, object.toString());
            }
        }
    }

    private boolean isOutputSingle(NativeWebRequest webRequest, Object handler, Class<?> type) {
        Boolean single = (Boolean)webRequest.getAttribute(WebRequestConstants.OUTPUT_SINGLE, 0);
        if (single == null) {
            return Collection.class.isAssignableFrom(type);
        }
        return single;
    }

    private MediaType findMediaType(NativeWebRequest webRequest) {
        List accepts = Arrays.asList(MediaType.ALL);
        MediaType mediaType = null;
        if (webRequest.getHeader("Accept") != null) {
            accepts = MediaType.parseMediaTypes((String)webRequest.getHeader("Accept"));
            for (MediaType accept : accepts) {
                if (!MediaType.ALL.equals((Object)accept) && MediaType.APPLICATION_JSON.isCompatibleWith(accept)) {
                    mediaType = MediaType.APPLICATION_JSON;
                    break;
                }
                if (mediaType != null) continue;
                mediaType = accept;
            }
        }
        if (mediaType == null) {
            mediaType = MediaType.APPLICATION_JSON;
        }
        return mediaType;
    }

    private boolean isPlainText(NativeWebRequest webRequest) {
        String value = webRequest.getHeader("Content-Type");
        if (value != null) {
            return MediaType.valueOf((String)value).isCompatibleWith(MediaType.TEXT_PLAIN);
        }
        return false;
    }

    private ResponseBodyEmitter getEmitter(Long timeout, Publisher<?> flux, MediaType mediaType, HttpHeaders request) {
        Mono exported;
        Object object = exported = flux instanceof Mono ? Mono.from(flux) : Flux.from(flux).timeout(Duration.ofMillis(timeout), (Publisher)Flux.empty());
        if (!MediaType.ALL.equals((Object)mediaType) && EVENT_STREAM.isCompatibleWith(mediaType)) {
            return new FluxResponseSseEmitter(request, MediaType.APPLICATION_JSON, (Publisher<?>)exported);
        }
        return new FluxResponseBodyEmitter(request, mediaType, (Publisher<?>)exported);
    }
}

