/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.distributed.AsyncBucketProxy;
import io.github.bucket4j.distributed.proxy.AsyncProxyManager;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.function.HandlerFilterFunction;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

public abstract class Bucket4jFilterFunctions {
    public static final String DEFAULT_HEADER_NAME = "X-RateLimit-Remaining";
    private static final Function<RateLimitConfig, BucketConfiguration> DEFAULT_CONFIGURATION_BUILDER = config -> BucketConfiguration.builder().addLimit(Bandwidth.builder().capacity(config.getCapacity()).refillGreedy(config.getCapacity(), config.getPeriod()).build()).build();

    private Bucket4jFilterFunctions() {
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> rateLimit(long capacity, Duration period, Function<ServerRequest, String> keyResolver) {
        return Bucket4jFilterFunctions.rateLimit(c -> c.setCapacity(capacity).setPeriod(period).setKeyResolver(keyResolver));
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> rateLimit(Consumer<RateLimitConfig> configConsumer) {
        RateLimitConfig config = new RateLimitConfig();
        configConsumer.accept(config);
        BucketConfiguration bucketConfiguration = config.getConfigurationBuilder().apply(config);
        return (request, next) -> {
            AsyncProxyManager proxyManager = (AsyncProxyManager)MvcUtils.getApplicationContext(request).getBean(AsyncProxyManager.class);
            String key = config.getKeyResolver().apply(request);
            if (!StringUtils.hasText((String)key)) {
                return ServerResponse.status((HttpStatusCode)HttpStatus.FORBIDDEN).build();
            }
            AsyncBucketProxy bucket = proxyManager.builder().build((Object)key, bucketConfiguration);
            CompletableFuture bucketFuture = bucket.tryConsumeAndReturnRemaining((long)config.getTokens());
            ConsumptionProbe consumptionProbe = config.getTimeout() != null ? (ConsumptionProbe)bucketFuture.get(config.getTimeout().toMillis(), TimeUnit.MILLISECONDS) : (ConsumptionProbe)bucketFuture.get();
            boolean allowed = consumptionProbe.isConsumed();
            long remainingTokens = consumptionProbe.getRemainingTokens();
            if (allowed) {
                ServerResponse serverResponse = next.handle(request);
                serverResponse.headers().add(config.getHeaderName(), String.valueOf(remainingTokens));
                return serverResponse;
            }
            return ((ServerResponse.BodyBuilder)ServerResponse.status((HttpStatusCode)config.getStatusCode()).header(config.getHeaderName(), new String[]{String.valueOf(remainingTokens)})).build();
        };
    }

    public static class RateLimitConfig {
        Function<RateLimitConfig, BucketConfiguration> configurationBuilder = DEFAULT_CONFIGURATION_BUILDER;
        long capacity;
        Duration period;
        Function<ServerRequest, String> keyResolver;
        HttpStatusCode statusCode = HttpStatus.TOO_MANY_REQUESTS;
        Duration timeout;
        int tokens = 1;
        String headerName = "X-RateLimit-Remaining";

        public Function<RateLimitConfig, BucketConfiguration> getConfigurationBuilder() {
            return this.configurationBuilder;
        }

        public void setConfigurationBuilder(Function<RateLimitConfig, BucketConfiguration> configurationBuilder) {
            Assert.notNull(configurationBuilder, (String)"configurationBuilder may not be null");
            this.configurationBuilder = configurationBuilder;
        }

        public long getCapacity() {
            return this.capacity;
        }

        public RateLimitConfig setCapacity(long capacity) {
            this.capacity = capacity;
            return this;
        }

        public Duration getPeriod() {
            return this.period;
        }

        public RateLimitConfig setPeriod(Duration period) {
            this.period = period;
            return this;
        }

        public Function<ServerRequest, String> getKeyResolver() {
            return this.keyResolver;
        }

        public RateLimitConfig setKeyResolver(Function<ServerRequest, String> keyResolver) {
            Assert.notNull(keyResolver, (String)"keyResolver may not be null");
            this.keyResolver = keyResolver;
            return this;
        }

        public HttpStatusCode getStatusCode() {
            return this.statusCode;
        }

        public RateLimitConfig setStatusCode(HttpStatusCode statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Duration getTimeout() {
            return this.timeout;
        }

        public RateLimitConfig setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public int getTokens() {
            return this.tokens;
        }

        public RateLimitConfig setTokens(int tokens) {
            Assert.isTrue((tokens > 0 ? 1 : 0) != 0, (String)"tokens must be greater than zero");
            this.tokens = tokens;
            return this;
        }

        public String getHeaderName() {
            return this.headerName;
        }

        public RateLimitConfig setHeaderName(String headerName) {
            Assert.notNull((Object)headerName, (String)"headerName may not be null");
            this.headerName = headerName;
            return this;
        }
    }

    static class FilterSupplier
    implements org.springframework.cloud.gateway.server.mvc.filter.FilterSupplier {
        FilterSupplier() {
        }

        @Override
        public Collection<Method> get() {
            return Arrays.asList(Bucket4jFilterFunctions.class.getMethods());
        }
    }
}

