/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.config;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.gateway.server.mvc.config.RouteProperties;
import org.springframework.core.style.ToStringCreator;

@ConfigurationProperties(value="spring.cloud.gateway.mvc")
public class GatewayMvcProperties {
    public static final String PREFIX = "spring.cloud.gateway.mvc";
    @NotNull
    @Valid
    private List<RouteProperties> routes = new ArrayList<RouteProperties>();
    @NotNull
    @Valid
    private LinkedHashMap<String, RouteProperties> routesMap = new LinkedHashMap();
    private HttpClient httpClient = new HttpClient();

    public List<RouteProperties> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<RouteProperties> routes) {
        this.routes = routes;
    }

    public LinkedHashMap<String, RouteProperties> getRoutesMap() {
        return this.routesMap;
    }

    public void setRoutesMap(LinkedHashMap<String, RouteProperties> routesMap) {
        this.routesMap = routesMap;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("httpClient", (Object)this.httpClient).append("routes", this.routes).append("routesMap", this.routesMap).toString();
    }

    public static class HttpClient {
        private Duration connectTimeout;
        private Duration readTimeout;
        private String sslBundle;
        private HttpClientType type = HttpClientType.JDK;

        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }

        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
        }

        public String getSslBundle() {
            return this.sslBundle;
        }

        public void setSslBundle(String sslBundle) {
            this.sslBundle = sslBundle;
        }

        public HttpClientType getType() {
            return this.type;
        }

        public void setType(HttpClientType type) {
            this.type = type;
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("connectTimeout", (Object)this.connectTimeout).append("readTimeout", (Object)this.readTimeout).append("sslBundle", (Object)this.sslBundle).append("type", (Object)this.type).toString();
        }
    }

    public static enum HttpClientType {
        JDK,
        AUTODETECT;

    }
}

