/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.handler.ClientHttpResponseAdapter;
import org.springframework.cloud.gateway.server.mvc.handler.GatewayServerResponse;
import org.springframework.cloud.gateway.server.mvc.handler.ProxyExchange;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;
import org.springframework.web.client.RestClient;
import org.springframework.web.servlet.function.ServerResponse;

public class RestClientProxyExchange
implements ProxyExchange {
    private final RestClient restClient;

    public RestClientProxyExchange(RestClient restClient) {
        this.restClient = restClient;
    }

    @Override
    public ServerResponse exchange(ProxyExchange.Request request) {
        return (ServerResponse)((RestClient.RequestBodySpec)((RestClient.RequestBodySpec)this.restClient.method(request.getMethod()).uri(request.getUri())).headers(httpHeaders -> httpHeaders.putAll((Map)request.getHeaders()))).body(outputStream -> RestClientProxyExchange.copyBody(request, outputStream)).exchange((clientRequest, clientResponse) -> RestClientProxyExchange.doExchange(request, (ClientHttpResponse)clientResponse), false);
    }

    private static int copyBody(ProxyExchange.Request request, OutputStream outputStream) throws IOException {
        return StreamUtils.copy((InputStream)request.getServerRequest().servletRequest().getInputStream(), (OutputStream)outputStream);
    }

    private static ServerResponse doExchange(ProxyExchange.Request request, ClientHttpResponse clientResponse) throws IOException {
        InputStream body = clientResponse.getBody();
        MvcUtils.putAttribute(request.getServerRequest(), MvcUtils.CLIENT_RESPONSE_INPUT_STREAM_ATTR, body);
        ServerResponse serverResponse = GatewayServerResponse.status(clientResponse.getStatusCode()).build((req, httpServletResponse) -> {
            try (ClientHttpResponse clientHttpResponse = clientResponse;){
                InputStream inputStream = (InputStream)MvcUtils.getAttribute(request.getServerRequest(), MvcUtils.CLIENT_RESPONSE_INPUT_STREAM_ATTR);
                StreamUtils.copy((InputStream)inputStream, (OutputStream)httpServletResponse.getOutputStream());
            }
            return null;
        });
        ClientHttpResponseAdapter proxyExchangeResponse = new ClientHttpResponseAdapter(clientResponse);
        request.getResponseConsumers().forEach(responseConsumer -> responseConsumer.accept(proxyExchangeResponse, serverResponse));
        return serverResponse;
    }
}

