/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.env.Environment;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.ConstructorResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.OperatorOverloader;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeComparator;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.TypedValue;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface ShortcutConfigurable {
    public static String normalizeKey(String key, int entryIdx, ShortcutConfigurable argHints, Map<String, String> args) {
        if (key.startsWith("_genkey_") && !argHints.shortcutFieldOrder().isEmpty() && entryIdx < args.size() && entryIdx < argHints.shortcutFieldOrder().size()) {
            key = argHints.shortcutFieldOrder().get(entryIdx);
        }
        return key;
    }

    public static Object getValue(SpelExpressionParser parser, BeanFactory beanFactory, String entryValue) {
        Object value;
        String rawValue = entryValue;
        if (rawValue != null) {
            rawValue = rawValue.trim();
        }
        if (rawValue != null && rawValue.startsWith("#{") && entryValue.endsWith("}")) {
            GatewayEvaluationContext context = new GatewayEvaluationContext(beanFactory);
            Expression expression = parser.parseExpression(entryValue, (ParserContext)new TemplateParserContext());
            value = expression.getValue((EvaluationContext)context);
        } else {
            value = entryValue;
        }
        return value;
    }

    default public ShortcutType shortcutType() {
        return ShortcutType.DEFAULT;
    }

    default public List<String> shortcutFieldOrder() {
        return Collections.emptyList();
    }

    default public String shortcutFieldPrefix() {
        return "";
    }

    public static class GatewayEvaluationContext
    implements EvaluationContext {
        private final BeanFactoryResolver beanFactoryResolver;
        private final SimpleEvaluationContext delegate;

        public GatewayEvaluationContext(BeanFactory beanFactory) {
            this.beanFactoryResolver = new BeanFactoryResolver(beanFactory);
            Environment env = (Environment)beanFactory.getBean(Environment.class);
            boolean restrictive = (Boolean)env.getProperty("spring.cloud.gateway.restrictive-property-accessor.enabled", Boolean.class, (Object)true);
            this.delegate = restrictive ? SimpleEvaluationContext.forPropertyAccessors((PropertyAccessor[])new PropertyAccessor[]{new RestrictivePropertyAccessor()}).withMethodResolvers(new MethodResolver[]{(context, targetObject, name, argumentTypes) -> null}).build() : SimpleEvaluationContext.forReadOnlyDataBinding().build();
        }

        public TypedValue getRootObject() {
            return this.delegate.getRootObject();
        }

        public List<PropertyAccessor> getPropertyAccessors() {
            return this.delegate.getPropertyAccessors();
        }

        public List<ConstructorResolver> getConstructorResolvers() {
            return this.delegate.getConstructorResolvers();
        }

        public List<MethodResolver> getMethodResolvers() {
            return this.delegate.getMethodResolvers();
        }

        @Nullable
        public BeanResolver getBeanResolver() {
            return this.beanFactoryResolver;
        }

        public TypeLocator getTypeLocator() {
            return this.delegate.getTypeLocator();
        }

        public TypeConverter getTypeConverter() {
            return this.delegate.getTypeConverter();
        }

        public TypeComparator getTypeComparator() {
            return this.delegate.getTypeComparator();
        }

        public OperatorOverloader getOperatorOverloader() {
            return this.delegate.getOperatorOverloader();
        }

        public void setVariable(String name, Object value) {
            this.delegate.setVariable(name, value);
        }

        @Nullable
        public Object lookupVariable(String name) {
            return this.delegate.lookupVariable(name);
        }
    }

    public static enum ShortcutType {
        DEFAULT{

            @Override
            public Map<String, Object> normalize(Map<String, String> args, ShortcutConfigurable shortcutConf, SpelExpressionParser parser, BeanFactory beanFactory) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                int entryIdx = 0;
                for (Map.Entry<String, String> entry : args.entrySet()) {
                    String key = ShortcutConfigurable.normalizeKey(entry.getKey(), entryIdx, shortcutConf, args);
                    Object value = ShortcutConfigurable.getValue(parser, beanFactory, entry.getValue());
                    map.put(key, value);
                    ++entryIdx;
                }
                return map;
            }
        }
        ,
        GATHER_LIST{

            @Override
            public Map<String, Object> normalize(Map<String, String> args, ShortcutConfigurable shortcutConf, SpelExpressionParser parser, BeanFactory beanFactory) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                List<String> fieldOrder = shortcutConf.shortcutFieldOrder();
                Assert.isTrue((fieldOrder != null && fieldOrder.size() == 1 ? 1 : 0) != 0, (String)"Shortcut Configuration Type GATHER_LIST must have shortcutFieldOrder of size 1");
                String fieldName = fieldOrder.get(0);
                map.put(fieldName, args.values().stream().map(value -> ShortcutConfigurable.getValue(parser, beanFactory, value)).collect(Collectors.toList()));
                return map;
            }
        }
        ,
        GATHER_LIST_TAIL_FLAG{

            @Override
            public Map<String, Object> normalize(Map<String, String> args, ShortcutConfigurable shortcutConf, SpelExpressionParser parser, BeanFactory beanFactory) {
                int lastIdx;
                String lastValue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                List<String> fieldOrder = shortcutConf.shortcutFieldOrder();
                Assert.isTrue((fieldOrder != null && fieldOrder.size() == 2 ? 1 : 0) != 0, (String)"Shortcut Configuration Type GATHER_LIST_HEAD must have shortcutFieldOrder of size 2");
                List<String> values = new ArrayList<String>(args.values());
                if (!values.isEmpty() && ((lastValue = (String)values.get(lastIdx = values.size() - 1)).equalsIgnoreCase("true") || lastValue.equalsIgnoreCase("false"))) {
                    values = values.subList(0, lastIdx);
                    map.put(fieldOrder.get(1), ShortcutConfigurable.getValue(parser, beanFactory, lastValue));
                }
                String fieldName = fieldOrder.get(0);
                map.put(fieldName, values.stream().map(value -> ShortcutConfigurable.getValue(parser, beanFactory, value)).collect(Collectors.toList()));
                return map;
            }
        };


        public abstract Map<String, Object> normalize(Map<String, String> var1, ShortcutConfigurable var2, SpelExpressionParser var3, BeanFactory var4);
    }

    public static class RestrictivePropertyAccessor
    extends ReflectivePropertyAccessor {
        public boolean canRead(EvaluationContext context, Object target, String name) {
            return false;
        }
    }
}

