/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.gateway.support.Configurable;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.ResolvableType;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

class ConfigurableHintsRegistrationProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final Log LOG = LogFactory.getLog(ConfigurableHintsRegistrationProcessor.class);
    private static final String ROOT_GATEWAY_PACKAGE_NAME = "org.springframework.cloud.gateway";

    ConfigurableHintsRegistrationProcessor() {
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        return (generationContext, beanFactoryInitializationCode) -> {
            ReflectionHints hints = generationContext.getRuntimeHints().reflection();
            ConfigurableHintsRegistrationProcessor.getConfigurableTypes().forEach(clazz -> hints.registerType(TypeReference.of((Class)clazz), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS})));
        };
    }

    private static Set<Class<?>> getConfigurableTypes() {
        Set<Class<?>> classesToAdd = ConfigurableHintsRegistrationProcessor.getClassesToAdd();
        HashSet genericsToAdd = new HashSet();
        for (Class<?> clazz : classesToAdd) {
            ResolvableType resolvableType = ResolvableType.forType(clazz);
            if (!resolvableType.getSuperType().hasGenerics()) continue;
            genericsToAdd.addAll(Arrays.stream(resolvableType.getSuperType().getGenerics()).map(ResolvableType::toClass).collect(Collectors.toSet()));
        }
        classesToAdd.addAll(genericsToAdd);
        return classesToAdd.stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static Set<Class<?>> getClassesToAdd() {
        HashSet classesToAdd = new HashSet();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Configurable.class));
        Set components = provider.findCandidateComponents(ROOT_GATEWAY_PACKAGE_NAME);
        for (BeanDefinition component : components) {
            try {
                Class<?> clazz = Class.forName(component.getBeanClassName());
                classesToAdd.add(clazz);
            }
            catch (ClassNotFoundException | NoClassDefFoundError exception) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)exception);
            }
        }
        return classesToAdd;
    }
}

