/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Secret;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigMapsCache;
import org.springframework.cloud.kubernetes.commons.config.SecretsCache;
import org.springframework.cloud.kubernetes.commons.config.StrippedSourceContainer;
import org.springframework.core.log.LogAccessor;

public class KubernetesClientSecretsCache
implements SecretsCache {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesClientConfigMapsCache.class));
    private static final ConcurrentHashMap<String, List<StrippedSourceContainer>> CACHE = new ConcurrentHashMap();

    public void discardAll() {
        CACHE.clear();
    }

    static List<StrippedSourceContainer> byNamespace(CoreV1Api coreV1Api, String namespace) {
        boolean[] b = new boolean[1];
        List result = CACHE.computeIfAbsent(namespace, x -> {
            try {
                b[0] = true;
                return KubernetesClientSecretsCache.strippedSecrets(coreV1Api.listNamespacedSecret(namespace, null, null, null, null, null, null, null, null, null, null).getItems());
            }
            catch (ApiException apiException) {
                throw new RuntimeException(apiException.getResponseBody(), apiException);
            }
        });
        if (b[0]) {
            LOG.debug(() -> "Loaded all secrets in namespace '" + namespace + "'");
        } else {
            LOG.debug(() -> "Loaded (from cache) all secrets in namespace '" + namespace + "'");
        }
        return result;
    }

    private static List<StrippedSourceContainer> strippedSecrets(List<V1Secret> secrets) {
        return secrets.stream().map(secret -> new StrippedSourceContainer(secret.getMetadata().getLabels(), secret.getMetadata().getName(), KubernetesClientSecretsCache.transform(secret.getData()))).collect(Collectors.toList());
    }

    private static Map<String, String> transform(Map<String, byte[]> in) {
        return in.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, en -> new String((byte[])en.getValue())));
    }
}

