/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.discovery.catalog;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.apis.CustomObjectsApi;
import io.kubernetes.client.openapi.models.V1APIResource;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.kubernetes.client.discovery.catalog.KubernetesCatalogWatchContext;
import org.springframework.cloud.kubernetes.client.discovery.catalog.KubernetesEndpointSlicesCatalogWatch;
import org.springframework.cloud.kubernetes.client.discovery.catalog.KubernetesEndpointsCatalogWatch;
import org.springframework.cloud.kubernetes.commons.KubernetesNamespaceProvider;
import org.springframework.cloud.kubernetes.commons.discovery.EndpointNameAndNamespace;
import org.springframework.cloud.kubernetes.commons.discovery.KubernetesDiscoveryProperties;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.scheduling.annotation.Scheduled;

class KubernetesCatalogWatch
implements ApplicationEventPublisherAware {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(KubernetesCatalogWatch.class));
    private final KubernetesCatalogWatchContext context;
    private Function<KubernetesCatalogWatchContext, List<EndpointNameAndNamespace>> stateGenerator;
    private volatile List<EndpointNameAndNamespace> catalogEndpointsState = null;
    private ApplicationEventPublisher publisher;

    KubernetesCatalogWatch(CoreV1Api coreV1Api, ApiClient apiClient, KubernetesDiscoveryProperties properties, KubernetesNamespaceProvider namespaceProvider) {
        this.context = new KubernetesCatalogWatchContext(coreV1Api, apiClient, properties, namespaceProvider);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Scheduled(fixedDelayString="${spring.cloud.kubernetes.discovery.catalogServicesWatchDelay:30000}")
    void catalogServicesWatch() {
        try {
            List<EndpointNameAndNamespace> currentState = this.stateGenerator.apply(this.context);
            if (!currentState.equals(this.catalogEndpointsState)) {
                LOG.debug(() -> "Received endpoints update from kubernetesClient: " + currentState);
                this.publisher.publishEvent((ApplicationEvent)new HeartbeatEvent((Object)this, currentState));
            }
            this.catalogEndpointsState = currentState;
        }
        catch (Exception e) {
            LOG.error((Throwable)e, () -> "Error watching Kubernetes Services");
        }
    }

    @PostConstruct
    void postConstruct() {
        this.stateGenerator = this.stateGenerator();
    }

    Function<KubernetesCatalogWatchContext, List<EndpointNameAndNamespace>> stateGenerator() {
        Function<KubernetesCatalogWatchContext, List<EndpointNameAndNamespace>> localStateGenerator;
        if (this.context.properties().useEndpointSlices()) {
            ApiClient apiClient = this.context.apiClient();
            CustomObjectsApi customObjectsApi = new CustomObjectsApi(apiClient);
            try {
                List resources = customObjectsApi.getAPIResources("discovery.k8s.io", "v1").getResources();
                boolean found = resources.stream().map(V1APIResource::getKind).anyMatch("EndpointSlice"::equals);
                if (!found) {
                    throw new IllegalArgumentException("EndpointSlices are not supported on the cluster");
                }
                localStateGenerator = new KubernetesEndpointSlicesCatalogWatch();
            }
            catch (ApiException e) {
                throw new RuntimeException(e);
            }
        } else {
            localStateGenerator = new KubernetesEndpointsCatalogWatch();
        }
        LOG.debug(() -> "stateGenerator is of type: " + localStateGenerator.getClass().getSimpleName());
        return localStateGenerator;
    }
}

