/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config.reload;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.bootstrap.config.BootstrapPropertySource;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.log.LogAccessor;

public final class ConfigReloadUtil {
    private static final LogAccessor LOG = new LogAccessor(LogFactory.getLog(ConfigReloadUtil.class));

    private ConfigReloadUtil() {
    }

    public static boolean reload(String target, String eventSourceType, PropertySourceLocator locator, ConfigurableEnvironment environment, Class<? extends MapPropertySource> existingSourcesType) {
        LOG.debug(() -> "onEvent " + target + ": " + eventSourceType);
        List<MapPropertySource> sourceFromK8s = ConfigReloadUtil.locateMapPropertySources(locator, environment);
        List<? extends MapPropertySource> existingSources = ConfigReloadUtil.findPropertySources(existingSourcesType, environment);
        boolean changed = ConfigReloadUtil.changed(sourceFromK8s, existingSources);
        if (changed) {
            LOG.info((CharSequence)"Detected change in config maps");
            return true;
        }
        LOG.debug((CharSequence)"No change detected in config maps, reload will not happen");
        return false;
    }

    public static <S extends PropertySource<?>> List<S> findPropertySources(Class<S> sourceClass, ConfigurableEnvironment environment) {
        ArrayList<PropertySource> managedSources = new ArrayList<PropertySource>();
        List sources = environment.getPropertySources().stream().collect(Collectors.toCollection(ArrayList::new));
        LOG.debug(() -> "environment: " + environment);
        LOG.debug(() -> "environment sources: " + sources);
        while (!sources.isEmpty()) {
            BootstrapPropertySource bootstrapPropertySource;
            PropertySource propertySource;
            PropertySource source = (PropertySource)sources.remove(0);
            if (source instanceof CompositePropertySource) {
                CompositePropertySource comp = (CompositePropertySource)source;
                sources.addAll(comp.getPropertySources());
                continue;
            }
            if (sourceClass.isInstance(source)) {
                managedSources.add((PropertySource)sourceClass.cast(source));
                continue;
            }
            if (!(source instanceof BootstrapPropertySource) || !sourceClass.isInstance(propertySource = (bootstrapPropertySource = (BootstrapPropertySource)source).getDelegate())) continue;
            sources.add(propertySource);
        }
        return managedSources;
    }

    static List<MapPropertySource> locateMapPropertySources(PropertySourceLocator propertySourceLocator, ConfigurableEnvironment environment) {
        ArrayList<MapPropertySource> result = new ArrayList<MapPropertySource>();
        PropertySource propertySource = propertySourceLocator.locate((Environment)environment);
        if (propertySource instanceof MapPropertySource) {
            MapPropertySource mapPropertySource = (MapPropertySource)propertySource;
            result.add(mapPropertySource);
        } else if (propertySource instanceof CompositePropertySource) {
            CompositePropertySource source = (CompositePropertySource)propertySource;
            source.getPropertySources().forEach(x -> {
                if (x instanceof MapPropertySource) {
                    MapPropertySource mapPropertySource = (MapPropertySource)x;
                    result.add(mapPropertySource);
                }
            });
        } else {
            LOG.debug(() -> "Found property source that cannot be handled: " + propertySource.getClass());
        }
        LOG.debug(() -> "environment: " + environment);
        LOG.debug(() -> "sources: " + result);
        return result;
    }

    static boolean changed(List<? extends MapPropertySource> left, List<? extends MapPropertySource> right) {
        if (left.size() != right.size()) {
            LOG.warn(() -> "The current number of ConfigMap PropertySources does not match the ones loaded from the Kubernetes - No reload will take place");
            if (LOG.isDebugEnabled()) {
                LOG.debug((CharSequence)("left size: " + left.size()));
                left.forEach(item -> LOG.debug((CharSequence)item.toString()));
                LOG.debug((CharSequence)("right size: " + right.size()));
                right.forEach(item -> LOG.debug((CharSequence)item.toString()));
            }
            return false;
        }
        for (int i = 0; i < left.size(); ++i) {
            if (!ConfigReloadUtil.changed(left.get(i), right.get(i))) continue;
            return true;
        }
        return false;
    }

    static boolean changed(MapPropertySource left, MapPropertySource right) {
        Map rightMap;
        if (left == right) {
            return false;
        }
        if (left == null || right == null) {
            return true;
        }
        Map leftMap = (Map)left.getSource();
        return !Objects.equals(leftMap, rightMap = (Map)right.getSource());
    }
}

