/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.config;

import io.fabric8.kubernetes.client.KubernetesClient;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.kubernetes.config.ConfigMapConfigProperties;
import org.springframework.cloud.kubernetes.config.ConfigMapPropertySource;
import org.springframework.cloud.kubernetes.config.ConfigUtils;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;

@Order(value=0)
public class ConfigMapPropertySourceLocator
implements PropertySourceLocator {
    private final KubernetesClient client;
    private final ConfigMapConfigProperties properties;

    public ConfigMapPropertySourceLocator(KubernetesClient client, ConfigMapConfigProperties properties) {
        this.client = client;
        this.properties = properties;
    }

    public MapPropertySource locate(Environment environment) {
        if (environment instanceof ConfigurableEnvironment) {
            ConfigurableEnvironment env = (ConfigurableEnvironment)environment;
            String name = ConfigUtils.getApplicationName(environment, this.properties);
            String namespace = ConfigUtils.getApplicationNamespace(this.client, (Environment)env, this.properties);
            return new ConfigMapPropertySource(this.client, name, namespace, env.getActiveProfiles(), this.properties);
        }
        return null;
    }
}

