/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.loadbalancer.annotation;

import java.util.Arrays;
import java.util.Objects;
import org.springframework.cloud.context.named.NamedContextFactory;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;

public class LoadBalancerClientSpecification
implements NamedContextFactory.Specification {
    private String name;
    private Class<?>[] configuration;

    public LoadBalancerClientSpecification() {
    }

    public LoadBalancerClientSpecification(String name, Class<?>[] configuration) {
        Assert.hasText((String)name, (String)"name must not be empty");
        this.name = name;
        Assert.notNull(configuration, (String)"configuration must not be null");
        this.configuration = configuration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Assert.hasText((String)name, (String)"name must not be empty");
        this.name = name;
    }

    public Class<?>[] getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Class<?>[] configuration) {
        Assert.notNull(configuration, (String)"configuration must not be null");
        this.configuration = configuration;
    }

    public String toString() {
        ToStringCreator to = new ToStringCreator((Object)this);
        to.append("name", (Object)this.name);
        to.append("configuration", this.configuration);
        return to.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadBalancerClientSpecification that = (LoadBalancerClientSpecification)o;
        return Objects.equals(this.name, that.name) && Arrays.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.configuration);
    }
}

