/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.HealthCheckHandler;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.client.CommonsClientAutoConfiguration;
import org.springframework.cloud.client.actuator.HasFeatures;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.noop.NoopDiscoveryClientAutoConfiguration;
import org.springframework.cloud.client.serviceregistry.AutoServiceRegistrationProperties;
import org.springframework.cloud.client.serviceregistry.ServiceRegistryAutoConfiguration;
import org.springframework.cloud.commons.util.IdUtils;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.netflix.eureka.CloudEurekaClient;
import org.springframework.cloud.netflix.eureka.CloudEurekaInstanceConfig;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.EurekaDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EurekaDiscoveryClientConfiguration;
import org.springframework.cloud.netflix.eureka.EurekaHealthIndicator;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.eureka.InstanceInfoFactory;
import org.springframework.cloud.netflix.eureka.config.DiscoveryClientOptionalArgsConfiguration;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaAutoServiceRegistration;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaServiceRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties
@ConditionalOnClass(value={EurekaClientConfig.class})
@Import(value={DiscoveryClientOptionalArgsConfiguration.class})
@ConditionalOnBean(value={EurekaDiscoveryClientConfiguration.Marker.class})
@ConditionalOnProperty(value={"eureka.client.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={NoopDiscoveryClientAutoConfiguration.class, CommonsClientAutoConfiguration.class, ServiceRegistryAutoConfiguration.class})
@AutoConfigureAfter(name={"org.springframework.cloud.autoconfigure.RefreshAutoConfiguration"})
public class EurekaClientAutoConfiguration {
    private static final Log log = LogFactory.getLog(EurekaClientAutoConfiguration.class);
    private ConfigurableEnvironment env;
    @Autowired(required=false)
    private HealthCheckHandler healthCheckHandler;

    public EurekaClientAutoConfiguration(ConfigurableEnvironment env) {
        this.env = env;
    }

    @Bean
    public HasFeatures eurekaFeature() {
        return HasFeatures.namedFeature((String)"Eureka Client", EurekaClient.class);
    }

    @Bean
    @ConditionalOnMissingBean(value={EurekaClientConfig.class}, search=SearchStrategy.CURRENT)
    public EurekaClientConfigBean eurekaClientConfigBean() {
        EurekaClientConfigBean client = new EurekaClientConfigBean();
        if ("bootstrap".equals(this.env.getProperty("spring.config.name"))) {
            client.setRegisterWithEureka(false);
        }
        return client;
    }

    private String getProperty(String property) {
        return this.env.containsProperty(property) ? this.env.getProperty(property) : "";
    }

    @Bean
    @ConditionalOnMissingBean(value={EurekaInstanceConfig.class}, search=SearchStrategy.CURRENT)
    public EurekaInstanceConfigBean eurekaInstanceConfigBean(InetUtils inetUtils) {
        String hostname = this.getProperty("eureka.instance.hostname");
        boolean preferIpAddress = Boolean.parseBoolean(this.getProperty("eureka.instance.prefer-ip-address"));
        int nonSecurePort = Integer.valueOf(this.env.getProperty("server.port", this.env.getProperty("port", "8080")));
        int managementPort = Integer.valueOf(this.env.getProperty("management.port", String.valueOf(nonSecurePort)));
        String managementContextPath = this.env.getProperty("management.context-path", this.env.getProperty("server.servlet.context-path", "/"));
        EurekaInstanceConfigBean instance = new EurekaInstanceConfigBean(inetUtils);
        instance.setNonSecurePort(nonSecurePort);
        instance.setInstanceId(IdUtils.getDefaultInstanceId((PropertyResolver)this.env));
        instance.setPreferIpAddress(preferIpAddress);
        if (managementPort != nonSecurePort && managementPort != 0) {
            if (StringUtils.hasText((String)hostname)) {
                instance.setHostname(hostname);
            }
            String statusPageUrlPath = this.getProperty("eureka.instance.status-page-url-path");
            String healthCheckUrlPath = this.getProperty("eureka.instance.health-check-url-path");
            if (!managementContextPath.endsWith("/")) {
                managementContextPath = managementContextPath + "/";
            }
            if (StringUtils.hasText((String)statusPageUrlPath)) {
                instance.setStatusPageUrlPath(statusPageUrlPath);
            }
            if (StringUtils.hasText((String)healthCheckUrlPath)) {
                instance.setHealthCheckUrlPath(healthCheckUrlPath);
            }
            String scheme = instance.getSecurePortEnabled() ? "https" : "http";
            try {
                URL base = new URL(scheme, instance.getHostname(), managementPort, managementContextPath);
                instance.setStatusPageUrl(new URL(base, StringUtils.trimLeadingCharacter((String)instance.getStatusPageUrlPath(), (char)'/')).toString());
                instance.setHealthCheckUrl(new URL(base, StringUtils.trimLeadingCharacter((String)instance.getHealthCheckUrlPath(), (char)'/')).toString());
            }
            catch (MalformedURLException e) {
                log.error((Object)"Unable to set status page or health check url.", (Throwable)e);
            }
        }
        return instance;
    }

    @Bean
    public DiscoveryClient discoveryClient(EurekaInstanceConfig config, EurekaClient client) {
        return new EurekaDiscoveryClient(config, client);
    }

    @Bean
    public EurekaServiceRegistry eurekaServiceRegistry() {
        return new EurekaServiceRegistry();
    }

    @Bean
    @ConditionalOnBean(value={AutoServiceRegistrationProperties.class})
    @ConditionalOnProperty(value={"spring.cloud.service-registry.auto-registration.enabled"}, matchIfMissing=true)
    public EurekaRegistration eurekaRegistration(EurekaClient eurekaClient, CloudEurekaInstanceConfig instanceConfig, ApplicationInfoManager applicationInfoManager) {
        return EurekaRegistration.builder(instanceConfig).with(applicationInfoManager).with(eurekaClient).with(this.healthCheckHandler).build();
    }

    @Bean
    @ConditionalOnBean(value={AutoServiceRegistrationProperties.class})
    @ConditionalOnProperty(value={"spring.cloud.service-registry.auto-registration.enabled"}, matchIfMissing=true)
    public EurekaAutoServiceRegistration eurekaAutoServiceRegistration(ApplicationContext context, EurekaServiceRegistry registry, EurekaRegistration registration) {
        return new EurekaAutoServiceRegistration(context, registry, registration);
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    protected static class EurekaHealthIndicatorConfiguration {
        protected EurekaHealthIndicatorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public EurekaHealthIndicator eurekaHealthIndicator(EurekaClient eurekaClient, EurekaInstanceConfig instanceConfig, EurekaClientConfig clientConfig) {
            return new EurekaHealthIndicator(eurekaClient, instanceConfig, clientConfig);
        }
    }

    private static class OnMissingRefreshScopeCondition
    extends AnyNestedCondition {
        public OnMissingRefreshScopeCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnMissingBean(value={RefreshAutoConfiguration.class})
        static class MissingScope {
            MissingScope() {
            }
        }

        @ConditionalOnMissingClass(value={"org.springframework.cloud.context.scope.refresh.RefreshScope"})
        static class MissingClass {
            MissingClass() {
            }
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @ConditionalOnClass(value={org.springframework.cloud.context.scope.refresh.RefreshScope.class})
    @ConditionalOnBean(value={RefreshAutoConfiguration.class})
    static @interface ConditionalOnRefreshScope {
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Conditional(value={OnMissingRefreshScopeCondition.class})
    static @interface ConditionalOnMissingRefreshScope {
    }

    @Configuration
    @ConditionalOnRefreshScope
    protected static class RefreshableEurekaClientConfiguration {
        @Autowired
        private ApplicationContext context;
        @Autowired
        private AbstractDiscoveryClientOptionalArgs<?> optionalArgs;

        protected RefreshableEurekaClientConfiguration() {
        }

        @Bean(destroyMethod="shutdown")
        @ConditionalOnMissingBean(value={EurekaClient.class}, search=SearchStrategy.CURRENT)
        @RefreshScope
        @Lazy
        public EurekaClient eurekaClient(ApplicationInfoManager manager, EurekaClientConfig config, EurekaInstanceConfig instance) {
            manager.getInfo();
            return new CloudEurekaClient(manager, config, this.optionalArgs, (ApplicationEventPublisher)this.context);
        }

        @Bean
        @ConditionalOnMissingBean(value={ApplicationInfoManager.class}, search=SearchStrategy.CURRENT)
        @RefreshScope
        @Lazy
        public ApplicationInfoManager eurekaApplicationInfoManager(EurekaInstanceConfig config) {
            InstanceInfo instanceInfo = new InstanceInfoFactory().create(config);
            return new ApplicationInfoManager(config, instanceInfo);
        }
    }

    @Configuration
    @ConditionalOnMissingRefreshScope
    protected static class EurekaClientConfiguration {
        @Autowired
        private ApplicationContext context;
        @Autowired
        private AbstractDiscoveryClientOptionalArgs<?> optionalArgs;

        protected EurekaClientConfiguration() {
        }

        @Bean(destroyMethod="shutdown")
        @ConditionalOnMissingBean(value={EurekaClient.class}, search=SearchStrategy.CURRENT)
        public EurekaClient eurekaClient(ApplicationInfoManager manager, EurekaClientConfig config) {
            return new CloudEurekaClient(manager, config, this.optionalArgs, (ApplicationEventPublisher)this.context);
        }

        @Bean
        @ConditionalOnMissingBean(value={ApplicationInfoManager.class}, search=SearchStrategy.CURRENT)
        public ApplicationInfoManager eurekaApplicationInfoManager(EurekaInstanceConfig config) {
            InstanceInfo instanceInfo = new InstanceInfoFactory().create(config);
            return new ApplicationInfoManager(config, instanceInfo);
        }
    }
}

