/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server;

import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.server.EurekaController;
import org.springframework.cloud.netflix.eureka.server.EurekaDashboardProperties;
import org.springframework.cloud.netflix.eureka.server.EurekaServerInitializerConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@Import(value={EurekaServerInitializerConfiguration.class})
@EnableDiscoveryClient
@EnableConfigurationProperties(value={EurekaDashboardProperties.class})
public class EurekaServerConfiguration
extends WebMvcConfigurerAdapter {
    private static String[] EUREKA_PACKAGES = new String[]{"com.netflix.discovery", "com.netflix.eureka"};

    @Bean
    @ConditionalOnProperty(prefix="eureka.dashboard", name={"enabled"}, matchIfMissing=true)
    public EurekaController eurekaController() {
        return new EurekaController();
    }

    @Bean
    public FilterRegistrationBean jerseyFilterRegistration(Application eurekaJerseyApp) {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)new ServletContainer(eurekaJerseyApp));
        bean.setOrder(Integer.MAX_VALUE);
        bean.setUrlPatterns(Collections.singletonList("/eureka/*"));
        return bean;
    }

    @Bean
    public Application jerseyApplication(Environment environment, ResourceLoader resourceLoader) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false, environment);
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Path.class));
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Provider.class));
        HashSet<Class> classes = new HashSet<Class>();
        String[] stringArray = EUREKA_PACKAGES;
        int n = EUREKA_PACKAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String basePackage = stringArray[n2];
            Set beans = provider.findCandidateComponents(basePackage);
            for (BeanDefinition bd : beans) {
                Class cls = ClassUtils.resolveClassName((String)bd.getBeanClassName(), (ClassLoader)resourceLoader.getClassLoader());
                classes.add(cls);
            }
            ++n2;
        }
        HashMap<String, String> propsAndFeatures = new HashMap<String, String>();
        propsAndFeatures.put("com.sun.jersey.config.property.WebPageContentRegex", "/eureka/(fonts|images|css|js)/.*");
        DefaultResourceConfig rc = new DefaultResourceConfig(classes);
        rc.setPropertiesAndFeatures(propsAndFeatures);
        return rc;
    }

    @Bean
    public FilterRegistrationBean traceFilterRegistration(@Qualifier(value="webRequestLoggingFilter") Filter filter) {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter(filter);
        bean.setOrder(0x7FFFFFF5);
        return bean;
    }
}

