/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.eureka.server;

import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.aws.AwsBindingStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.env.PropertyResolver;

@ConfigurationProperties(value="eureka.server")
public class EurekaServerConfigBean
implements EurekaServerConfig {
    public static final String PREFIX = "eureka.server";
    private static final int MINUTES = 60000;
    @Autowired(required=false)
    PropertyResolver propertyResolver;
    private String aWSAccessId;
    private String aWSSecretKey;
    private int eIPBindRebindRetries = 3;
    private int eIPBindingRetryIntervalMs = 300000;
    private int eIPBindingRetryIntervalMsWhenUnbound = 60000;
    private boolean enableSelfPreservation = true;
    private double renewalPercentThreshold = 0.85;
    private int renewalThresholdUpdateIntervalMs = 900000;
    private int peerEurekaNodesUpdateIntervalMs = 600000;
    private int numberOfReplicationRetries = 5;
    private int peerEurekaStatusRefreshTimeIntervalMs = 30000;
    private int waitTimeInMsWhenSyncEmpty = 300000;
    private int peerNodeConnectTimeoutMs = 200;
    private int peerNodeReadTimeoutMs = 200;
    private int peerNodeTotalConnections = 1000;
    private int peerNodeTotalConnectionsPerHost = 500;
    private int peerNodeConnectionIdleTimeoutSeconds = 30;
    private long retentionTimeInMSInDeltaQueue = 180000L;
    private long deltaRetentionTimerIntervalInMs = 30000L;
    private long evictionIntervalTimerInMs = 60000L;
    private int aSGQueryTimeoutMs = 300;
    private long aSGUpdateIntervalMs = 300000L;
    private long aSGCacheExpiryTimeoutMs = 600000L;
    private long responseCacheAutoExpirationInSeconds = 180L;
    private long responseCacheUpdateIntervalMs = 30000L;
    private boolean useReadOnlyResponseCache = true;
    private boolean disableDelta;
    private long maxIdleThreadInMinutesAgeForStatusReplication = 10L;
    private int minThreadsForStatusReplication = 1;
    private int maxThreadsForStatusReplication = 1;
    private int maxElementsInStatusReplicationPool = 10000;
    private boolean syncWhenTimestampDiffers = true;
    private int registrySyncRetries = 0;
    private long registrySyncRetryWaitMs = 30000L;
    private int maxElementsInPeerReplicationPool = 10000;
    private long maxIdleThreadAgeInMinutesForPeerReplication = 15L;
    private int minThreadsForPeerReplication = 5;
    private int maxThreadsForPeerReplication = 20;
    private int maxTimeForReplication = 30000;
    private boolean primeAwsReplicaConnections = true;
    private boolean disableDeltaForRemoteRegions;
    private int remoteRegionConnectTimeoutMs = 1000;
    private int remoteRegionReadTimeoutMs = 1000;
    private int remoteRegionTotalConnections = 1000;
    private int remoteRegionTotalConnectionsPerHost = 500;
    private int remoteRegionConnectionIdleTimeoutSeconds = 30;
    private boolean gZipContentFromRemoteRegion = true;
    private Map<String, String> remoteRegionUrlsWithName = new HashMap<String, String>();
    private String[] remoteRegionUrls;
    private Map<String, Set<String>> remoteRegionAppWhitelist;
    private int remoteRegionRegistryFetchInterval = 30;
    private int remoteRegionFetchThreadPoolSize = 20;
    private String remoteRegionTrustStore = "";
    private String remoteRegionTrustStorePassword = "changeit";
    private boolean disableTransparentFallbackToOtherRegion;
    private boolean batchReplication;
    private boolean rateLimiterEnabled = false;
    private boolean rateLimiterThrottleStandardClients = false;
    private Set<String> rateLimiterPrivilegedClients = Collections.emptySet();
    private int rateLimiterBurstSize = 10;
    private int rateLimiterRegistryFetchAverageRate = 500;
    private int rateLimiterFullFetchAverageRate = 100;
    private boolean logIdentityHeaders = true;
    private String listAutoScalingGroupsRoleName = "ListAutoScalingGroups";
    private boolean enableReplicatedRequestCompression = false;
    private String jsonCodecName;
    private String xmlCodecName;
    private int route53BindRebindRetries = 3;
    private int route53BindingRetryIntervalMs = 300000;
    private long route53DomainTTL = 30L;
    private AwsBindingStrategy bindingStrategy = AwsBindingStrategy.EIP;
    private int minAvailableInstancesForPeerReplication = -1;

    public boolean shouldEnableSelfPreservation() {
        return this.enableSelfPreservation;
    }

    public boolean shouldDisableDelta() {
        return this.disableDelta;
    }

    public boolean shouldSyncWhenTimestampDiffers() {
        return this.syncWhenTimestampDiffers;
    }

    public boolean shouldPrimeAwsReplicaConnections() {
        return this.primeAwsReplicaConnections;
    }

    public boolean shouldDisableDeltaForRemoteRegions() {
        return this.disableDeltaForRemoteRegions;
    }

    public boolean shouldGZipContentFromRemoteRegion() {
        return this.gZipContentFromRemoteRegion;
    }

    public Set<String> getRemoteRegionAppWhitelist(String regionName) {
        return this.remoteRegionAppWhitelist.get(regionName == null ? "global" : regionName.trim().toLowerCase());
    }

    public boolean disableTransparentFallbackToOtherRegion() {
        return this.disableTransparentFallbackToOtherRegion;
    }

    public boolean shouldBatchReplication() {
        return this.batchReplication;
    }

    public boolean shouldLogIdentityHeaders() {
        return this.logIdentityHeaders;
    }

    public String getJsonCodecName() {
        return this.jsonCodecName;
    }

    public String getXmlCodecName() {
        return this.xmlCodecName;
    }

    public boolean shouldUseReadOnlyResponseCache() {
        return this.useReadOnlyResponseCache;
    }

    public boolean shouldEnableReplicatedRequestCompression() {
        return this.enableReplicatedRequestCompression;
    }

    public String getExperimental(String name) {
        if (this.propertyResolver != null) {
            return (String)this.propertyResolver.getProperty("eureka.server.experimental." + name, String.class, null);
        }
        return null;
    }

    public int getHealthStatusMinNumberOfAvailablePeers() {
        return this.minAvailableInstancesForPeerReplication;
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public void setPropertyResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public String getAWSAccessId() {
        return this.aWSAccessId;
    }

    public void setAWSAccessId(String aWSAccessId) {
        this.aWSAccessId = aWSAccessId;
    }

    public String getAWSSecretKey() {
        return this.aWSSecretKey;
    }

    public void setAWSSecretKey(String aWSSecretKey) {
        this.aWSSecretKey = aWSSecretKey;
    }

    public int getEIPBindRebindRetries() {
        return this.eIPBindRebindRetries;
    }

    public void setEIPBindRebindRetries(int eIPBindRebindRetries) {
        this.eIPBindRebindRetries = eIPBindRebindRetries;
    }

    public int getEIPBindingRetryIntervalMs() {
        return this.eIPBindingRetryIntervalMs;
    }

    public void setEIPBindingRetryIntervalMs(int eIPBindingRetryIntervalMs) {
        this.eIPBindingRetryIntervalMs = eIPBindingRetryIntervalMs;
    }

    public int getEIPBindingRetryIntervalMsWhenUnbound() {
        return this.eIPBindingRetryIntervalMsWhenUnbound;
    }

    public void setEIPBindingRetryIntervalMsWhenUnbound(int eIPBindingRetryIntervalMsWhenUnbound) {
        this.eIPBindingRetryIntervalMsWhenUnbound = eIPBindingRetryIntervalMsWhenUnbound;
    }

    public boolean isEnableSelfPreservation() {
        return this.enableSelfPreservation;
    }

    public void setEnableSelfPreservation(boolean enableSelfPreservation) {
        this.enableSelfPreservation = enableSelfPreservation;
    }

    public double getRenewalPercentThreshold() {
        return this.renewalPercentThreshold;
    }

    public void setRenewalPercentThreshold(double renewalPercentThreshold) {
        this.renewalPercentThreshold = renewalPercentThreshold;
    }

    public int getRenewalThresholdUpdateIntervalMs() {
        return this.renewalThresholdUpdateIntervalMs;
    }

    public void setRenewalThresholdUpdateIntervalMs(int renewalThresholdUpdateIntervalMs) {
        this.renewalThresholdUpdateIntervalMs = renewalThresholdUpdateIntervalMs;
    }

    public int getPeerEurekaNodesUpdateIntervalMs() {
        return this.peerEurekaNodesUpdateIntervalMs;
    }

    public void setPeerEurekaNodesUpdateIntervalMs(int peerEurekaNodesUpdateIntervalMs) {
        this.peerEurekaNodesUpdateIntervalMs = peerEurekaNodesUpdateIntervalMs;
    }

    public int getNumberOfReplicationRetries() {
        return this.numberOfReplicationRetries;
    }

    public void setNumberOfReplicationRetries(int numberOfReplicationRetries) {
        this.numberOfReplicationRetries = numberOfReplicationRetries;
    }

    public int getPeerEurekaStatusRefreshTimeIntervalMs() {
        return this.peerEurekaStatusRefreshTimeIntervalMs;
    }

    public void setPeerEurekaStatusRefreshTimeIntervalMs(int peerEurekaStatusRefreshTimeIntervalMs) {
        this.peerEurekaStatusRefreshTimeIntervalMs = peerEurekaStatusRefreshTimeIntervalMs;
    }

    public int getWaitTimeInMsWhenSyncEmpty() {
        return this.waitTimeInMsWhenSyncEmpty;
    }

    public void setWaitTimeInMsWhenSyncEmpty(int waitTimeInMsWhenSyncEmpty) {
        this.waitTimeInMsWhenSyncEmpty = waitTimeInMsWhenSyncEmpty;
    }

    public int getPeerNodeConnectTimeoutMs() {
        return this.peerNodeConnectTimeoutMs;
    }

    public void setPeerNodeConnectTimeoutMs(int peerNodeConnectTimeoutMs) {
        this.peerNodeConnectTimeoutMs = peerNodeConnectTimeoutMs;
    }

    public int getPeerNodeReadTimeoutMs() {
        return this.peerNodeReadTimeoutMs;
    }

    public void setPeerNodeReadTimeoutMs(int peerNodeReadTimeoutMs) {
        this.peerNodeReadTimeoutMs = peerNodeReadTimeoutMs;
    }

    public int getPeerNodeTotalConnections() {
        return this.peerNodeTotalConnections;
    }

    public void setPeerNodeTotalConnections(int peerNodeTotalConnections) {
        this.peerNodeTotalConnections = peerNodeTotalConnections;
    }

    public int getPeerNodeTotalConnectionsPerHost() {
        return this.peerNodeTotalConnectionsPerHost;
    }

    public void setPeerNodeTotalConnectionsPerHost(int peerNodeTotalConnectionsPerHost) {
        this.peerNodeTotalConnectionsPerHost = peerNodeTotalConnectionsPerHost;
    }

    public int getPeerNodeConnectionIdleTimeoutSeconds() {
        return this.peerNodeConnectionIdleTimeoutSeconds;
    }

    public void setPeerNodeConnectionIdleTimeoutSeconds(int peerNodeConnectionIdleTimeoutSeconds) {
        this.peerNodeConnectionIdleTimeoutSeconds = peerNodeConnectionIdleTimeoutSeconds;
    }

    public long getRetentionTimeInMSInDeltaQueue() {
        return this.retentionTimeInMSInDeltaQueue;
    }

    public void setRetentionTimeInMSInDeltaQueue(long retentionTimeInMSInDeltaQueue) {
        this.retentionTimeInMSInDeltaQueue = retentionTimeInMSInDeltaQueue;
    }

    public long getDeltaRetentionTimerIntervalInMs() {
        return this.deltaRetentionTimerIntervalInMs;
    }

    public void setDeltaRetentionTimerIntervalInMs(long deltaRetentionTimerIntervalInMs) {
        this.deltaRetentionTimerIntervalInMs = deltaRetentionTimerIntervalInMs;
    }

    public long getEvictionIntervalTimerInMs() {
        return this.evictionIntervalTimerInMs;
    }

    public void setEvictionIntervalTimerInMs(long evictionIntervalTimerInMs) {
        this.evictionIntervalTimerInMs = evictionIntervalTimerInMs;
    }

    public int getASGQueryTimeoutMs() {
        return this.aSGQueryTimeoutMs;
    }

    public void setASGQueryTimeoutMs(int aSGQueryTimeoutMs) {
        this.aSGQueryTimeoutMs = aSGQueryTimeoutMs;
    }

    public long getASGUpdateIntervalMs() {
        return this.aSGUpdateIntervalMs;
    }

    public void setASGUpdateIntervalMs(long aSGUpdateIntervalMs) {
        this.aSGUpdateIntervalMs = aSGUpdateIntervalMs;
    }

    public long getASGCacheExpiryTimeoutMs() {
        return this.aSGCacheExpiryTimeoutMs;
    }

    public void setASGCacheExpiryTimeoutMs(long aSGCacheExpiryTimeoutMs) {
        this.aSGCacheExpiryTimeoutMs = aSGCacheExpiryTimeoutMs;
    }

    public long getResponseCacheAutoExpirationInSeconds() {
        return this.responseCacheAutoExpirationInSeconds;
    }

    public void setResponseCacheAutoExpirationInSeconds(long responseCacheAutoExpirationInSeconds) {
        this.responseCacheAutoExpirationInSeconds = responseCacheAutoExpirationInSeconds;
    }

    public long getResponseCacheUpdateIntervalMs() {
        return this.responseCacheUpdateIntervalMs;
    }

    public void setResponseCacheUpdateIntervalMs(long responseCacheUpdateIntervalMs) {
        this.responseCacheUpdateIntervalMs = responseCacheUpdateIntervalMs;
    }

    public boolean isUseReadOnlyResponseCache() {
        return this.useReadOnlyResponseCache;
    }

    public void setUseReadOnlyResponseCache(boolean useReadOnlyResponseCache) {
        this.useReadOnlyResponseCache = useReadOnlyResponseCache;
    }

    public boolean isDisableDelta() {
        return this.disableDelta;
    }

    public void setDisableDelta(boolean disableDelta) {
        this.disableDelta = disableDelta;
    }

    public long getMaxIdleThreadInMinutesAgeForStatusReplication() {
        return this.maxIdleThreadInMinutesAgeForStatusReplication;
    }

    public void setMaxIdleThreadInMinutesAgeForStatusReplication(long maxIdleThreadInMinutesAgeForStatusReplication) {
        this.maxIdleThreadInMinutesAgeForStatusReplication = maxIdleThreadInMinutesAgeForStatusReplication;
    }

    public int getMinThreadsForStatusReplication() {
        return this.minThreadsForStatusReplication;
    }

    public void setMinThreadsForStatusReplication(int minThreadsForStatusReplication) {
        this.minThreadsForStatusReplication = minThreadsForStatusReplication;
    }

    public int getMaxThreadsForStatusReplication() {
        return this.maxThreadsForStatusReplication;
    }

    public void setMaxThreadsForStatusReplication(int maxThreadsForStatusReplication) {
        this.maxThreadsForStatusReplication = maxThreadsForStatusReplication;
    }

    public int getMaxElementsInStatusReplicationPool() {
        return this.maxElementsInStatusReplicationPool;
    }

    public void setMaxElementsInStatusReplicationPool(int maxElementsInStatusReplicationPool) {
        this.maxElementsInStatusReplicationPool = maxElementsInStatusReplicationPool;
    }

    public boolean isSyncWhenTimestampDiffers() {
        return this.syncWhenTimestampDiffers;
    }

    public void setSyncWhenTimestampDiffers(boolean syncWhenTimestampDiffers) {
        this.syncWhenTimestampDiffers = syncWhenTimestampDiffers;
    }

    public int getRegistrySyncRetries() {
        return this.registrySyncRetries;
    }

    public void setRegistrySyncRetries(int registrySyncRetries) {
        this.registrySyncRetries = registrySyncRetries;
    }

    public long getRegistrySyncRetryWaitMs() {
        return this.registrySyncRetryWaitMs;
    }

    public void setRegistrySyncRetryWaitMs(long registrySyncRetryWaitMs) {
        this.registrySyncRetryWaitMs = registrySyncRetryWaitMs;
    }

    public int getMaxElementsInPeerReplicationPool() {
        return this.maxElementsInPeerReplicationPool;
    }

    public void setMaxElementsInPeerReplicationPool(int maxElementsInPeerReplicationPool) {
        this.maxElementsInPeerReplicationPool = maxElementsInPeerReplicationPool;
    }

    public long getMaxIdleThreadAgeInMinutesForPeerReplication() {
        return this.maxIdleThreadAgeInMinutesForPeerReplication;
    }

    public void setMaxIdleThreadAgeInMinutesForPeerReplication(long maxIdleThreadAgeInMinutesForPeerReplication) {
        this.maxIdleThreadAgeInMinutesForPeerReplication = maxIdleThreadAgeInMinutesForPeerReplication;
    }

    public int getMinThreadsForPeerReplication() {
        return this.minThreadsForPeerReplication;
    }

    public void setMinThreadsForPeerReplication(int minThreadsForPeerReplication) {
        this.minThreadsForPeerReplication = minThreadsForPeerReplication;
    }

    public int getMaxThreadsForPeerReplication() {
        return this.maxThreadsForPeerReplication;
    }

    public void setMaxThreadsForPeerReplication(int maxThreadsForPeerReplication) {
        this.maxThreadsForPeerReplication = maxThreadsForPeerReplication;
    }

    public int getMaxTimeForReplication() {
        return this.maxTimeForReplication;
    }

    public void setMaxTimeForReplication(int maxTimeForReplication) {
        this.maxTimeForReplication = maxTimeForReplication;
    }

    public boolean isPrimeAwsReplicaConnections() {
        return this.primeAwsReplicaConnections;
    }

    public void setPrimeAwsReplicaConnections(boolean primeAwsReplicaConnections) {
        this.primeAwsReplicaConnections = primeAwsReplicaConnections;
    }

    public boolean isDisableDeltaForRemoteRegions() {
        return this.disableDeltaForRemoteRegions;
    }

    public void setDisableDeltaForRemoteRegions(boolean disableDeltaForRemoteRegions) {
        this.disableDeltaForRemoteRegions = disableDeltaForRemoteRegions;
    }

    public int getRemoteRegionConnectTimeoutMs() {
        return this.remoteRegionConnectTimeoutMs;
    }

    public void setRemoteRegionConnectTimeoutMs(int remoteRegionConnectTimeoutMs) {
        this.remoteRegionConnectTimeoutMs = remoteRegionConnectTimeoutMs;
    }

    public int getRemoteRegionReadTimeoutMs() {
        return this.remoteRegionReadTimeoutMs;
    }

    public void setRemoteRegionReadTimeoutMs(int remoteRegionReadTimeoutMs) {
        this.remoteRegionReadTimeoutMs = remoteRegionReadTimeoutMs;
    }

    public int getRemoteRegionTotalConnections() {
        return this.remoteRegionTotalConnections;
    }

    public void setRemoteRegionTotalConnections(int remoteRegionTotalConnections) {
        this.remoteRegionTotalConnections = remoteRegionTotalConnections;
    }

    public int getRemoteRegionTotalConnectionsPerHost() {
        return this.remoteRegionTotalConnectionsPerHost;
    }

    public void setRemoteRegionTotalConnectionsPerHost(int remoteRegionTotalConnectionsPerHost) {
        this.remoteRegionTotalConnectionsPerHost = remoteRegionTotalConnectionsPerHost;
    }

    public int getRemoteRegionConnectionIdleTimeoutSeconds() {
        return this.remoteRegionConnectionIdleTimeoutSeconds;
    }

    public void setRemoteRegionConnectionIdleTimeoutSeconds(int remoteRegionConnectionIdleTimeoutSeconds) {
        this.remoteRegionConnectionIdleTimeoutSeconds = remoteRegionConnectionIdleTimeoutSeconds;
    }

    public boolean isgZipContentFromRemoteRegion() {
        return this.gZipContentFromRemoteRegion;
    }

    public void setgZipContentFromRemoteRegion(boolean gZipContentFromRemoteRegion) {
        this.gZipContentFromRemoteRegion = gZipContentFromRemoteRegion;
    }

    public Map<String, String> getRemoteRegionUrlsWithName() {
        return this.remoteRegionUrlsWithName;
    }

    public void setRemoteRegionUrlsWithName(Map<String, String> remoteRegionUrlsWithName) {
        this.remoteRegionUrlsWithName = remoteRegionUrlsWithName;
    }

    public String[] getRemoteRegionUrls() {
        return this.remoteRegionUrls;
    }

    public void setRemoteRegionUrls(String[] remoteRegionUrls) {
        this.remoteRegionUrls = remoteRegionUrls;
    }

    public Map<String, Set<String>> getRemoteRegionAppWhitelist() {
        return this.remoteRegionAppWhitelist;
    }

    public void setRemoteRegionAppWhitelist(Map<String, Set<String>> remoteRegionAppWhitelist) {
        this.remoteRegionAppWhitelist = remoteRegionAppWhitelist;
    }

    public int getRemoteRegionRegistryFetchInterval() {
        return this.remoteRegionRegistryFetchInterval;
    }

    public void setRemoteRegionRegistryFetchInterval(int remoteRegionRegistryFetchInterval) {
        this.remoteRegionRegistryFetchInterval = remoteRegionRegistryFetchInterval;
    }

    public int getRemoteRegionFetchThreadPoolSize() {
        return this.remoteRegionFetchThreadPoolSize;
    }

    public void setRemoteRegionFetchThreadPoolSize(int remoteRegionFetchThreadPoolSize) {
        this.remoteRegionFetchThreadPoolSize = remoteRegionFetchThreadPoolSize;
    }

    public String getRemoteRegionTrustStore() {
        return this.remoteRegionTrustStore;
    }

    public void setRemoteRegionTrustStore(String remoteRegionTrustStore) {
        this.remoteRegionTrustStore = remoteRegionTrustStore;
    }

    public String getRemoteRegionTrustStorePassword() {
        return this.remoteRegionTrustStorePassword;
    }

    public void setRemoteRegionTrustStorePassword(String remoteRegionTrustStorePassword) {
        this.remoteRegionTrustStorePassword = remoteRegionTrustStorePassword;
    }

    public boolean isDisableTransparentFallbackToOtherRegion() {
        return this.disableTransparentFallbackToOtherRegion;
    }

    public void setDisableTransparentFallbackToOtherRegion(boolean disableTransparentFallbackToOtherRegion) {
        this.disableTransparentFallbackToOtherRegion = disableTransparentFallbackToOtherRegion;
    }

    public boolean isBatchReplication() {
        return this.batchReplication;
    }

    public void setBatchReplication(boolean batchReplication) {
        this.batchReplication = batchReplication;
    }

    public boolean isRateLimiterEnabled() {
        return this.rateLimiterEnabled;
    }

    public void setRateLimiterEnabled(boolean rateLimiterEnabled) {
        this.rateLimiterEnabled = rateLimiterEnabled;
    }

    public boolean isRateLimiterThrottleStandardClients() {
        return this.rateLimiterThrottleStandardClients;
    }

    public void setRateLimiterThrottleStandardClients(boolean rateLimiterThrottleStandardClients) {
        this.rateLimiterThrottleStandardClients = rateLimiterThrottleStandardClients;
    }

    public Set<String> getRateLimiterPrivilegedClients() {
        return this.rateLimiterPrivilegedClients;
    }

    public void setRateLimiterPrivilegedClients(Set<String> rateLimiterPrivilegedClients) {
        this.rateLimiterPrivilegedClients = rateLimiterPrivilegedClients;
    }

    public int getRateLimiterBurstSize() {
        return this.rateLimiterBurstSize;
    }

    public void setRateLimiterBurstSize(int rateLimiterBurstSize) {
        this.rateLimiterBurstSize = rateLimiterBurstSize;
    }

    public int getRateLimiterRegistryFetchAverageRate() {
        return this.rateLimiterRegistryFetchAverageRate;
    }

    public void setRateLimiterRegistryFetchAverageRate(int rateLimiterRegistryFetchAverageRate) {
        this.rateLimiterRegistryFetchAverageRate = rateLimiterRegistryFetchAverageRate;
    }

    public int getRateLimiterFullFetchAverageRate() {
        return this.rateLimiterFullFetchAverageRate;
    }

    public void setRateLimiterFullFetchAverageRate(int rateLimiterFullFetchAverageRate) {
        this.rateLimiterFullFetchAverageRate = rateLimiterFullFetchAverageRate;
    }

    public boolean isLogIdentityHeaders() {
        return this.logIdentityHeaders;
    }

    public void setLogIdentityHeaders(boolean logIdentityHeaders) {
        this.logIdentityHeaders = logIdentityHeaders;
    }

    public String getListAutoScalingGroupsRoleName() {
        return this.listAutoScalingGroupsRoleName;
    }

    public void setListAutoScalingGroupsRoleName(String listAutoScalingGroupsRoleName) {
        this.listAutoScalingGroupsRoleName = listAutoScalingGroupsRoleName;
    }

    public boolean isEnableReplicatedRequestCompression() {
        return this.enableReplicatedRequestCompression;
    }

    public void setEnableReplicatedRequestCompression(boolean enableReplicatedRequestCompression) {
        this.enableReplicatedRequestCompression = enableReplicatedRequestCompression;
    }

    public void setJsonCodecName(String jsonCodecName) {
        this.jsonCodecName = jsonCodecName;
    }

    public void setXmlCodecName(String xmlCodecName) {
        this.xmlCodecName = xmlCodecName;
    }

    public int getRoute53BindRebindRetries() {
        return this.route53BindRebindRetries;
    }

    public void setRoute53BindRebindRetries(int route53BindRebindRetries) {
        this.route53BindRebindRetries = route53BindRebindRetries;
    }

    public int getRoute53BindingRetryIntervalMs() {
        return this.route53BindingRetryIntervalMs;
    }

    public void setRoute53BindingRetryIntervalMs(int route53BindingRetryIntervalMs) {
        this.route53BindingRetryIntervalMs = route53BindingRetryIntervalMs;
    }

    public long getRoute53DomainTTL() {
        return this.route53DomainTTL;
    }

    public void setRoute53DomainTTL(long route53DomainTTL) {
        this.route53DomainTTL = route53DomainTTL;
    }

    public AwsBindingStrategy getBindingStrategy() {
        return this.bindingStrategy;
    }

    public void setBindingStrategy(AwsBindingStrategy bindingStrategy) {
        this.bindingStrategy = bindingStrategy;
    }

    public int getMinAvailableInstancesForPeerReplication() {
        return this.minAvailableInstancesForPeerReplication;
    }

    public void setMinAvailableInstancesForPeerReplication(int minAvailableInstancesForPeerReplication) {
        this.minAvailableInstancesForPeerReplication = minAvailableInstancesForPeerReplication;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

