/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.metrics.spectator;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Registry;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.boot.actuate.metrics.reader.MetricReader;

public class SpectatorMetricReader
implements MetricReader {
    private Registry registry;

    public SpectatorMetricReader(Registry registry) {
        this.registry = registry;
    }

    protected static String asHierarchicalName(Id id) {
        List tags = StreamSupport.stream(id.tags().spliterator(), false).map(t -> t.key() + "=" + t.value()).collect(Collectors.toList());
        return id.name() + "(" + String.join((CharSequence)",", tags) + ")";
    }

    public Metric<?> findOne(String name) {
        throw new UnsupportedOperationException("cannot construct a tag-based Spectator id from a hierarchical name");
    }

    public Iterable<Metric<?>> findAll() {
        return StreamSupport.stream(this.registry.spliterator(), false).flatMap(metric -> StreamSupport.stream(metric.measure().spliterator(), false).map(measure -> new Metric(SpectatorMetricReader.asHierarchicalName(measure.id()), (Number)measure.value()))).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).collect(Collectors.toList());
    }

    public long count() {
        return StreamSupport.stream(this.registry.spliterator(), false).flatMap(m -> StreamSupport.stream(m.measure().spliterator(), false)).count();
    }
}

