/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.metrics.spectator;

import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.MonitorRegistry;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.servo.ServoRegistry;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.endpoint.MetricReaderPublicMetrics;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.actuate.metrics.reader.MetricReader;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.netflix.metrics.DefaultMetricsTagProvider;
import org.springframework.cloud.netflix.metrics.MetricsInterceptorConfiguration;
import org.springframework.cloud.netflix.metrics.MetricsTagProvider;
import org.springframework.cloud.netflix.metrics.servo.ServoMetricsConfigBean;
import org.springframework.cloud.netflix.metrics.servo.ServoMonitorCache;
import org.springframework.cloud.netflix.metrics.spectator.SpectatorMetricReader;
import org.springframework.cloud.netflix.metrics.spectator.SpectatorMetricServices;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={MetricRepositoryAutoConfiguration.class})
@ConditionalOnClass(value={Registry.class, MetricReader.class})
@Import(value={MetricsInterceptorConfiguration.class})
public class SpectatorMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ServoMetricsConfigBean servoMetricsConfig() {
        return new ServoMetricsConfigBean();
    }

    @Bean
    @ConditionalOnMissingBean
    public MonitorRegistry monitorRegistry(ServoMetricsConfigBean configBean) {
        System.setProperty(DefaultMonitorRegistry.class.getCanonicalName() + ".registryClass", configBean.getRegistryClass());
        return DefaultMonitorRegistry.getInstance();
    }

    @Bean
    @ConditionalOnMissingBean(value={Registry.class})
    Registry registry(MonitorRegistry monitorRegistry) {
        return new ServoRegistry();
    }

    @Bean
    public ServoMonitorCache monitorCache(MonitorRegistry monitorRegistry, ServoMetricsConfigBean configBean) {
        return new ServoMonitorCache(monitorRegistry, configBean);
    }

    @Bean
    @ConditionalOnMissingBean(value={CounterService.class, GaugeService.class})
    public SpectatorMetricServices spectatorMetricServices(Registry metricRegistry) {
        return new SpectatorMetricServices(metricRegistry);
    }

    @Bean
    public MetricReaderPublicMetrics spectatorPublicMetrics(Registry metricRegistry) {
        SpectatorMetricReader reader = new SpectatorMetricReader(metricRegistry);
        return new MetricReaderPublicMetrics((MetricReader)reader);
    }

    @Bean
    public MetricsTagProvider defaultMetricsTagProvider() {
        return new DefaultMetricsTagProvider();
    }
}

