/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine.amqp;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.util.StringUtils;
import rx.subjects.PublishSubject;

@MessageEndpoint
public class Aggregator {
    private static final Log log = LogFactory.getLog(Aggregator.class);
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private PublishSubject<Map<String, Object>> subject;

    @ServiceActivator(inputChannel="hystrixStreamAggregator")
    public void handle(String payload) {
        try {
            Map map = (Map)this.objectMapper.readValue(payload, Map.class);
            Map<String, Object> data = Aggregator.getPayloadData(map);
            log.debug((Object)("Received hystrix stream payload: " + data));
            this.subject.onNext(data);
        }
        catch (IOException ex) {
            log.error((Object)("Error receiving hystrix stream payload: " + payload), (Throwable)ex);
        }
    }

    public static Map<String, Object> getPayloadData(Map<String, Object> jsonMap) {
        Map origin = (Map)jsonMap.get("origin");
        String instanceId = null;
        if (origin.containsKey("id")) {
            instanceId = origin.get("id").toString();
        }
        if (!StringUtils.hasText(instanceId)) {
            instanceId = origin.get("serviceId") + ":" + origin.get("host") + ":" + origin.get("port");
        }
        Map data = (Map)jsonMap.get("data");
        data.put("instanceId", instanceId);
        return data;
    }
}

