/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.turbine.amqp;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.turbine.amqp.Aggregator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.dsl.IntegrationFlow;
import org.springframework.integration.dsl.IntegrationFlowBuilder;
import org.springframework.integration.dsl.IntegrationFlows;
import org.springframework.integration.dsl.amqp.Amqp;
import org.springframework.integration.dsl.core.MessageProducerSpec;

@Configuration
@ConditionalOnClass(value={AmqpTemplate.class})
@ConditionalOnProperty(value={"turbine.amqp.enabled"}, matchIfMissing=true)
public class TurbineAmqpAutoConfiguration {
    @Autowired
    private ConnectionFactory connectionFactory;
    @Autowired
    private RabbitTemplate amqpTemplate;
    @Autowired(required=false)
    private ObjectMapper objectMapper;

    @PostConstruct
    public void init() {
        Jackson2JsonMessageConverter converter = this.messageConverter();
        this.amqpTemplate.setMessageConverter((MessageConverter)converter);
    }

    @Bean
    public DirectExchange hystrixStreamExchange() {
        DirectExchange exchange = new DirectExchange("spring.cloud.hystrix.stream");
        return exchange;
    }

    @Bean
    protected Binding localTurbineAmqpQueueBinding() {
        return BindingBuilder.bind((Queue)this.hystrixStreamQueue()).to(this.hystrixStreamExchange()).with("");
    }

    @Bean
    public Queue hystrixStreamQueue() {
        HashMap<String, Integer> args = new HashMap<String, Integer>();
        args.put("x-message-ttl", 60000);
        Queue queue = new Queue("spring.cloud.hystrix.stream", false, false, false, args);
        return queue;
    }

    @Bean
    public IntegrationFlow hystrixStreamAggregatorInboundFlow() {
        return ((IntegrationFlowBuilder)IntegrationFlows.from((MessageProducerSpec)Amqp.inboundAdapter((ConnectionFactory)this.connectionFactory, (Queue[])new Queue[]{this.hystrixStreamQueue()}).messageConverter((MessageConverter)this.messageConverter())).channel("hystrixStreamAggregator")).get();
    }

    @Bean
    public Aggregator hystrixStreamAggregator() {
        return new Aggregator();
    }

    private Jackson2JsonMessageConverter messageConverter() {
        Jackson2JsonMessageConverter converter = new Jackson2JsonMessageConverter();
        if (this.objectMapper != null) {
            converter.setJsonObjectMapper(this.objectMapper);
        }
        return converter;
    }
}

