/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.security.oauth2.client;

import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.client.loadbalancer.LoadBalancerInterceptor;
import org.springframework.cloud.security.oauth2.client.OAuth2ClientAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;

@Configuration
@ConditionalOnClass(value={LoadBalancerInterceptor.class, OAuth2RestTemplate.class})
@AutoConfigureBefore(value={OAuth2ClientAutoConfiguration.class})
public class OAuth2LoadBalancerClientAutoConfiguration {
    @Autowired(required=false)
    private LoadBalancerInterceptor loadBalancerInterceptor;
    @Autowired(required=false)
    private OAuth2RestTemplate restTemplate;

    @PostConstruct
    public void addInterceptor() {
        if (this.restTemplate != null && this.loadBalancerInterceptor != null) {
            ArrayList<LoadBalancerInterceptor> interceptors = new ArrayList<LoadBalancerInterceptor>(this.restTemplate.getInterceptors());
            interceptors.add(this.loadBalancerInterceptor);
            this.restTemplate.setInterceptors(interceptors);
        }
    }
}

