/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.domain;

import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.springframework.cloud.skipper.domain.AbstractEntity;
import org.springframework.cloud.skipper.domain.Status;
import org.springframework.cloud.skipper.domain.StatusCode;

@Entity
@Table(name="SkipperInfo")
public class Info
extends AbstractEntity {
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(foreignKey=@ForeignKey(name="fk_info_status"))
    private Status status;
    private Date firstDeployed;
    private Date lastDeployed;
    private Date deleted;
    private String description;

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Date getFirstDeployed() {
        return this.firstDeployed;
    }

    public void setFirstDeployed(Date firstDeployed) {
        this.firstDeployed = firstDeployed;
    }

    public Date getLastDeployed() {
        return this.lastDeployed;
    }

    public void setLastDeployed(Date lastDeployed) {
        this.lastDeployed = lastDeployed;
    }

    public Date getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Date deleted) {
        this.deleted = deleted;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static Info createNewInfo(String description) {
        Info info = new Info();
        info.setFirstDeployed(new Date());
        info.setLastDeployed(new Date());
        Status status = new Status();
        status.setStatusCode(StatusCode.UNKNOWN);
        info.setStatus(status);
        info.setDescription(description);
        return info;
    }
}

