/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.Diff;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class PropertiesDiff {
    private Map<String, String> removed = new HashMap<String, String>();
    private Map<String, String> added = new HashMap<String, String>();
    private Map<String, String> common = new HashMap<String, String>();
    private Map<String, PropertyChange> changed = new HashMap<String, PropertyChange>();

    private PropertiesDiff(Map<String, String> removed, Map<String, String> added, Map<String, String> common, Map<String, PropertyChange> changed) {
        this.removed = removed;
        this.added = added;
        this.common = common;
        this.changed = changed;
    }

    public Map<String, String> getRemoved() {
        return this.removed;
    }

    public Map<String, String> getAdded() {
        return this.added;
    }

    public Map<String, String> getCommon() {
        return this.common;
    }

    public Map<String, PropertyChange> getChanged() {
        return this.changed;
    }

    public boolean areEqual() {
        return this.removed.isEmpty() && this.added.isEmpty() && this.changed.isEmpty();
    }

    public String toString() {
        return "PropertiesDiff [added=" + this.added + ", removed=" + this.removed + ", changed=" + this.changed + ", common=" + this.common + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> removed = new HashMap<String, String>();
        private final Map<String, String> added = new HashMap<String, String>();
        private final Map<String, String> common = new HashMap<String, String>();
        private final Map<String, PropertyChange> changed = new HashMap<String, PropertyChange>();
        private final Map<String, String> leftMap = new HashMap<String, String>();
        private final Map<String, String> rightMap = new HashMap<String, String>();

        public Builder left(Map<String, String> leftMap) {
            this.leftMap.putAll(leftMap);
            return this;
        }

        public Builder right(Map<String, String> rightMap) {
            this.rightMap.putAll(rightMap);
            return this;
        }

        public PropertiesDiff build() {
            DiffBuilder leftBuilder = new DiffBuilder(this.leftMap, this.rightMap, ToStringStyle.DEFAULT_STYLE);
            DiffBuilder rightBuilder = new DiffBuilder(this.leftMap, this.rightMap, ToStringStyle.DEFAULT_STYLE);
            for (Map.Entry<String, String> entry : this.leftMap.entrySet()) {
                leftBuilder.append(entry.getKey(), (Object)entry.getValue(), (Object)this.rightMap.get(entry.getKey()));
            }
            for (Map.Entry<String, String> entry : this.rightMap.entrySet()) {
                rightBuilder.append(entry.getKey(), (Object)entry.getValue(), (Object)this.leftMap.get(entry.getKey()));
            }
            DiffResult leftResult = leftBuilder.build();
            for (Diff diff : leftResult) {
                this.leftMap.remove(diff.getFieldName());
                if (diff.getRight() == null) {
                    this.removed.put(diff.getFieldName(), diff.getLeft().toString());
                    continue;
                }
                this.changed.put(diff.getFieldName(), new PropertyChange(diff.getLeft().toString(), diff.getRight().toString()));
            }
            this.common.putAll(this.leftMap);
            DiffResult diffResult = rightBuilder.build();
            for (Diff diff : diffResult) {
                if (diff.getRight() != null) continue;
                this.added.put(diff.getFieldName(), diff.getLeft().toString());
            }
            return new PropertiesDiff(this.removed, this.added, this.common, this.changed);
        }
    }

    public static class PropertyChange {
        private final String original;
        private final String replaced;

        public PropertyChange(String original, String replaced) {
            this.original = original;
            this.replaced = replaced;
        }

        public String getOriginal() {
            return this.original;
        }

        public String getReplaced() {
            return this.replaced;
        }

        public String toString() {
            return "original=" + this.original + ", replaced=" + this.replaced;
        }
    }
}

