/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.skipper.support.yaml;

import java.util.ArrayList;
import java.util.List;

public class YamlConversionStatus {
    public static final YamlConversionStatus EMPTY = new YamlConversionStatus();
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    private int severity;
    private List<ConversionMessage> entries = new ArrayList<ConversionMessage>();

    void addError(String message) {
        this.entries.add(new ConversionMessage(2, message));
        if (this.severity < 2) {
            this.severity = 2;
        }
    }

    void addWarning(String message) {
        this.entries.add(new ConversionMessage(1, message));
        if (this.severity < 1) {
            this.severity = 1;
        }
    }

    public List<ConversionMessage> getEntries() {
        return this.entries;
    }

    public int getSeverity() {
        return this.severity;
    }

    static class ConversionMessage {
        private int severity;
        private String message;

        ConversionMessage(int severity, String message) {
            this.severity = severity;
            this.message = message;
        }

        public int getSeverity() {
            return this.severity;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

