/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.Span;
import brave.Tracer;
import brave.propagation.TraceContextOrSamplingFlags;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveSpan;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;

class BraveSpanBuilder
implements Span.Builder {
    brave.Span delegate;
    TraceContextOrSamplingFlags parentContext;
    private final Tracer tracer;
    private long startTimestamp;

    BraveSpanBuilder(Tracer tracer) {
        this.tracer = tracer;
    }

    BraveSpanBuilder(Tracer tracer, TraceContextOrSamplingFlags parentContext) {
        this.tracer = tracer;
        this.parentContext = parentContext;
    }

    brave.Span span() {
        if (this.delegate != null) {
            return this.delegate;
        }
        this.delegate = this.parentContext != null ? this.tracer.nextSpan(this.parentContext) : this.tracer.nextSpan();
        return this.delegate;
    }

    public Span.Builder setParent(TraceContext context) {
        this.parentContext = TraceContextOrSamplingFlags.create((brave.propagation.TraceContext)BraveTraceContext.toBrave(context));
        return this;
    }

    public Span.Builder setNoParent() {
        return this;
    }

    public Span.Builder name(String name) {
        this.span().name(name);
        return this;
    }

    public Span.Builder event(String value) {
        this.span().annotate(value);
        return this;
    }

    public Span.Builder tag(String key, String value) {
        this.span().tag(key, value);
        return this;
    }

    public Span.Builder error(Throwable throwable) {
        this.span().error(throwable);
        return this;
    }

    public Span.Builder kind(Span.Kind kind) {
        this.span().kind(kind != null ? Span.Kind.valueOf((String)kind.toString()) : null);
        return this;
    }

    public Span.Builder remoteServiceName(String remoteServiceName) {
        this.span().remoteServiceName(remoteServiceName);
        return this;
    }

    public Span.Builder remoteIpAndPort(String ip, int port) {
        this.span().remoteIpAndPort(ip, port);
        return this;
    }

    public Span start() {
        if (this.startTimestamp > 0L) {
            this.span().start(this.startTimestamp);
        } else {
            this.span().start();
        }
        return BraveSpan.fromBrave(this.delegate);
    }

    static Span.Builder toBuilder(Tracer tracer, TraceContextOrSamplingFlags context) {
        return new BraveSpanBuilder(tracer, context);
    }

    public String toString() {
        return "{ delegate='" + this.delegate + "', parentContext='" + this.parentContext + "', startTimestamp='" + this.startTimestamp + "'}";
    }
}

