/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.bridge;

import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagation;
import brave.baggage.BaggagePropagationConfig;
import brave.internal.baggage.BaggageFields;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.BaggageInScope;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.brave.bridge.BraveBaggageInScope;
import org.springframework.cloud.sleuth.brave.bridge.BraveBaggageManager;
import org.springframework.cloud.sleuth.brave.bridge.BraveTraceContext;
import org.springframework.util.StringUtils;

class W3CBaggagePropagator {
    private static final Log log = LogFactory.getLog(W3CBaggagePropagator.class);
    private static final String TRACE_STATE = "tracestate";
    private static final BaggageField TRACE_STATE_BAGGAGE = BaggageField.create((String)"tracestate");
    private static final String FIELD = "baggage";
    private static final List<String> FIELDS = Collections.singletonList("baggage");
    private final BraveBaggageManager braveBaggageManager;
    private final List<String> localFields;

    W3CBaggagePropagator(BraveBaggageManager braveBaggageManager, List<String> localFields) {
        this.braveBaggageManager = braveBaggageManager;
        this.localFields = localFields;
    }

    private BaggagePropagation.FactoryBuilder factory() {
        return BaggagePropagation.newFactoryBuilder((Propagation.Factory)new Propagation.Factory(){

            public <K> Propagation<K> create(Propagation.KeyFactory<K> keyFactory) {
                return null;
            }
        });
    }

    public List<String> keys() {
        return FIELDS;
    }

    public <R> TraceContext.Injector<R> injector(Propagation.Setter<R, String> setter) {
        return (context, carrier) -> {
            BaggageFields extra = (BaggageFields)context.findExtra(BaggageFields.class);
            if (extra == null || extra.getAllFields().isEmpty()) {
                return;
            }
            StringBuilder headerContent = new StringBuilder();
            String[] strings = this.localFields.toArray(new String[0]);
            Map filtered = extra.toMapFilteringFieldNames(strings);
            for (Map.Entry entry : filtered.entrySet()) {
                if (TRACE_STATE.equalsIgnoreCase((String)entry.getKey())) continue;
                headerContent.append((String)entry.getKey()).append("=").append((String)entry.getValue());
                headerContent.append(",");
            }
            if (headerContent.length() > 0) {
                headerContent.setLength(headerContent.length() - 1);
                setter.put(carrier, (Object)FIELD, headerContent.toString());
            }
        };
    }

    <R> TraceContextOrSamplingFlags contextWithBaggage(R carrier, TraceContextOrSamplingFlags flags, Propagation.Getter<R, String> getter) {
        String baggageHeader;
        BaggagePropagation.FactoryBuilder factoryBuilder = this.factory();
        String traceState = getter.get(carrier, (Object)TRACE_STATE);
        boolean hasTraceState = StringUtils.hasText((String)traceState);
        if (hasTraceState) {
            factoryBuilder = factoryBuilder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.remote((BaggageField)TRACE_STATE_BAGGAGE));
        }
        List<AbstractMap.SimpleEntry> pairs = (baggageHeader = getter.get(carrier, (Object)FIELD)) == null || baggageHeader.isEmpty() ? Collections.emptyList() : this.addBaggageToContext(baggageHeader);
        Set names = pairs.stream().map(e -> ((BaggageInScope)e.getKey()).name()).collect(Collectors.toSet());
        for (String name : names) {
            factoryBuilder = factoryBuilder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.remote((BaggageField)((BraveBaggageInScope)this.braveBaggageManager.createBaggage(name)).unwrap()));
        }
        brave.propagation.TraceContext decoratedContext = factoryBuilder.build().decorate(flags.context());
        if (hasTraceState) {
            BaggageInScope baggageInScope = this.braveBaggageManager.createBaggage(TRACE_STATE);
            baggageInScope.set((TraceContext)new BraveTraceContext(decoratedContext), traceState);
        }
        pairs.forEach(e -> {
            BaggageField baggage = ((BraveBaggageInScope)e.getKey()).unwrap();
            baggage.updateValue(decoratedContext, (String)e.getValue());
        });
        return TraceContextOrSamplingFlags.create((brave.propagation.TraceContext)decoratedContext);
    }

    List<AbstractMap.SimpleEntry<BaggageInScope, String>> addBaggageToContext(String baggageHeader) {
        String[] entries;
        ArrayList<AbstractMap.SimpleEntry<BaggageInScope, String>> pairs = new ArrayList<AbstractMap.SimpleEntry<BaggageInScope, String>>();
        for (String entry : entries = baggageHeader.split(",")) {
            int beginningOfMetadata = entry.indexOf(";");
            if (beginningOfMetadata > 0) {
                entry = entry.substring(0, beginningOfMetadata);
            }
            Object[] keyAndValue = entry.split("=");
            for (int i = 0; i < keyAndValue.length; i += 2) {
                try {
                    String key = keyAndValue[i].trim();
                    String value = keyAndValue[i + 1].trim();
                    BaggageInScope baggage = this.braveBaggageManager.createBaggage(key);
                    pairs.add(new AbstractMap.SimpleEntry<BaggageInScope, String>(baggage, value));
                    continue;
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Exception occurred while trying to parse baggage with key value [" + Arrays.toString(keyAndValue) + "]. Will ignore that entry."), (Throwable)e);
                }
            }
        }
        return pairs;
    }
}

