/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.messaging;

import brave.Tracer;
import brave.kafka.clients.KafkaTracing;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.cloud.sleuth.brave.instrument.messaging.MessageListenerMethodInterceptor;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.MessageListenerContainer;

@Aspect
public class SleuthKafkaAspect {
    private static final Log log = LogFactory.getLog(SleuthKafkaAspect.class);
    private final KafkaTracing kafkaTracing;
    private final Tracer tracer;

    public SleuthKafkaAspect(KafkaTracing kafkaTracing, Tracer tracer) {
        this.kafkaTracing = kafkaTracing;
        this.tracer = tracer;
    }

    @Pointcut(value="execution(public * org.springframework.kafka.config.KafkaListenerContainerFactory.createListenerContainer(..))")
    private void anyCreateListenerContainer() {
    }

    @Pointcut(value="execution(public * org.springframework.kafka.config.KafkaListenerContainerFactory.createContainer(..))")
    private void anyCreateContainer() {
    }

    @Around(value="anyCreateListenerContainer() || anyCreateContainer()")
    public Object wrapListenerContainerCreation(ProceedingJoinPoint pjp) throws Throwable {
        MessageListenerContainer listener = (MessageListenerContainer)pjp.proceed();
        if (listener instanceof AbstractMessageListenerContainer) {
            AbstractMessageListenerContainer container = (AbstractMessageListenerContainer)listener;
            Object someMessageListener = container.getContainerProperties().getMessageListener();
            if (someMessageListener == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No message listener to wrap. Proceeding");
                }
            } else if (someMessageListener instanceof MessageListener) {
                container.setupMessageListener(this.createProxy(someMessageListener));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"ATM we don't support Batch message listeners");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Can't wrap this listener. Proceeding");
        }
        return listener;
    }

    Object createProxy(Object bean) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(true);
        factory.addAdvice(new MessageListenerMethodInterceptor(this.kafkaTracing, this.tracer));
        factory.setTarget(bean);
        return factory.getObject();
    }
}

