/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.util.concurrent.Callable;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Signal;
import reactor.core.publisher.SignalType;
import reactor.util.context.Context;

public final class WebFluxSleuthOperators {
    private static final Log log = LogFactory.getLog(WebFluxSleuthOperators.class);

    private WebFluxSleuthOperators() {
        throw new IllegalStateException("You can't instantiate a utility class");
    }

    public static Consumer<Signal> withSpanInScope(SignalType signalType, Runnable runnable) {
        return signal -> {
            if (signalType != signal.getType()) {
                return;
            }
            WebFluxSleuthOperators.withSpanInScope(runnable).accept((Signal)signal);
        };
    }

    public static Consumer<Signal> withSpanInScope(SignalType signalType, Consumer<Signal> consumer) {
        return signal -> {
            if (signalType != signal.getType()) {
                return;
            }
            WebFluxSleuthOperators.withSpanInScope(signal.getContext(), () -> consumer.accept((Signal)signal));
        };
    }

    public static Consumer<Signal> withSpanInScope(Runnable runnable) {
        return signal -> {
            Context context = signal.getContext();
            WebFluxSleuthOperators.withSpanInScope(context, runnable);
        };
    }

    public static void withSpanInScope(Context context, Runnable runnable) {
        CurrentTraceContext currentTraceContext = (CurrentTraceContext)context.get(CurrentTraceContext.class);
        TraceContext traceContext = WebFluxSleuthOperators.traceContextOrNew(context);
        try (CurrentTraceContext.Scope scope = currentTraceContext.maybeScope(traceContext);){
            runnable.run();
        }
    }

    public static <T> T withSpanInScope(Context context, Callable<T> callable) {
        CurrentTraceContext currentTraceContext = (CurrentTraceContext)context.get(CurrentTraceContext.class);
        TraceContext traceContext = WebFluxSleuthOperators.traceContextOrNew(context);
        return WebFluxSleuthOperators.withContext(callable, currentTraceContext, traceContext);
    }

    private static TraceContext traceContextOrNew(Context context) {
        Tracer tracer = (Tracer)context.get(Tracer.class);
        if (!context.hasKey(TraceContext.class)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No trace context found, will create a new span");
            }
            return tracer.nextSpan().context();
        }
        return (TraceContext)context.get(TraceContext.class);
    }

    public static void withSpanInScope(Tracer tracer, CurrentTraceContext currentTraceContext, ServerWebExchange exchange, Runnable runnable) {
        Span span = WebFluxSleuthOperators.spanFromExchangeOrNew(tracer, exchange);
        try (CurrentTraceContext.Scope scope = currentTraceContext.maybeScope(span.context());){
            runnable.run();
        }
    }

    public static <T> T withSpanInScope(Tracer tracer, CurrentTraceContext currentTraceContext, ServerWebExchange exchange, Callable<T> callable) {
        Span span = WebFluxSleuthOperators.spanFromExchangeOrNew(tracer, exchange);
        return WebFluxSleuthOperators.withContext(callable, currentTraceContext, span.context());
    }

    public static TraceContext currentTraceContext(ServerWebExchange exchange) {
        return (TraceContext)exchange.getAttribute(TraceContext.class.getName());
    }

    public static TraceContext currentTraceContext(Context context) {
        return (TraceContext)context.getOrDefault(TraceContext.class, null);
    }

    public static TraceContext currentTraceContext(Signal signal) {
        return WebFluxSleuthOperators.currentTraceContext(signal.getContext());
    }

    private static <T> T withContext(Callable<T> callable, CurrentTraceContext currentTraceContext, TraceContext traceContext) {
        Throwable throwable = null;
        try (CurrentTraceContext.Scope scope = currentTraceContext.maybeScope(traceContext);){
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static Span spanFromExchangeOrNew(Tracer tracer, ServerWebExchange exchange) {
        Span span = (Span)exchange.getAttribute(Span.class.getName());
        if (span == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No trace context found, will create a new span");
            }
            span = tracer.nextSpan();
        }
        return span;
    }
}

