/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscription;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.http.HttpClientRequest;
import org.springframework.cloud.sleuth.http.HttpClientResponse;
import org.springframework.cloud.sleuth.instrument.reactor.TraceContextPropagator;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public final class TraceExchangeFilterFunction
implements ExchangeFilterFunction {
    private static final Log log = LogFactory.getLog(TraceExchangeFilterFunction.class);
    final ConfigurableApplicationContext springContext;
    HttpClientHandler handler;
    CurrentTraceContext currentTraceContext;

    TraceExchangeFilterFunction(ConfigurableApplicationContext springContext) {
        this.springContext = springContext;
    }

    public static ExchangeFilterFunction create(ConfigurableApplicationContext springContext) {
        return new TraceExchangeFilterFunction(springContext);
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        return new MonoWebClientTrace(next, request, this);
    }

    CurrentTraceContext currentTraceContext() {
        if (this.currentTraceContext == null) {
            this.currentTraceContext = (CurrentTraceContext)this.springContext.getBean(CurrentTraceContext.class);
        }
        return this.currentTraceContext;
    }

    HttpClientHandler handler() {
        if (this.handler == null) {
            this.handler = (HttpClientHandler)this.springContext.getBean(HttpClientHandler.class);
        }
        return this.handler;
    }

    static final class ClientResponseWrapper
    implements HttpClientResponse {
        final ClientResponse delegate;

        ClientResponseWrapper(ClientResponse delegate) {
            this.delegate = delegate;
        }

        public Collection<String> headerNames() {
            return this.delegate.headers().asHttpHeaders().keySet();
        }

        public Object unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            return Math.max(this.delegate.rawStatusCode(), 0);
        }

        public String header(String header) {
            List headers = this.delegate.headers().header(header);
            if (headers.isEmpty()) {
                return null;
            }
            return (String)headers.get(0);
        }
    }

    private static final class ClientRequestWrapper
    implements HttpClientRequest {
        final ClientRequest delegate;
        final ClientRequest.Builder builder;

        ClientRequestWrapper(ClientRequest delegate) {
            this.delegate = delegate;
            this.builder = ClientRequest.from((ClientRequest)delegate);
        }

        public Collection<String> headerNames() {
            return this.delegate.headers().keySet();
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.method().name();
        }

        public String path() {
            return this.delegate.url().getPath();
        }

        public String url() {
            return this.delegate.url().toString();
        }

        public String header(String name) {
            return this.delegate.headers().getFirst(name);
        }

        public void header(String name, String value) {
            this.builder.header(name, new String[]{value});
        }

        ClientRequest buildRequest() {
            return this.builder.build();
        }
    }

    static class TraceWebClientSubscription
    implements Subscription {
        static final Exception CANCELLED_ERROR = new CancellationException("CANCELLED"){

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        };
        final AtomicReference<Span> pendingSpan;
        final Subscription delegate;
        volatile boolean requested;

        TraceWebClientSubscription(Subscription delegate, AtomicReference<Span> pendingSpan) {
            this.delegate = delegate;
            this.pendingSpan = pendingSpan;
        }

        public void request(long n) {
            this.requested = true;
            this.delegate.request(n);
        }

        public void cancel() {
            this.delegate.cancel();
            Span span = this.pendingSpan.getAndSet(null);
            if (span != null) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Subscription was cancelled. TraceWebClientBeanPostProcessor Will close the span [" + span + "]"));
                }
                if (!this.requested) {
                    span.abandon();
                } else {
                    span.error((Throwable)CANCELLED_ERROR);
                    span.end();
                }
            }
        }
    }

    static final class TraceWebClientSubscriber
    extends AtomicReference<Span>
    implements CoreSubscriber<ClientResponse>,
    Scannable {
        final CoreSubscriber<? super ClientResponse> actual;
        final Context context;
        @Nullable
        final TraceContext parent;
        final HttpClientHandler handler;
        final CurrentTraceContext currentTraceContext;

        TraceWebClientSubscriber(CoreSubscriber<? super ClientResponse> actual, Context ctx, Span clientSpan, TraceContext parent, MonoWebClientTrace mono) {
            this.actual = actual;
            this.parent = parent;
            this.handler = mono.handler;
            this.currentTraceContext = mono.currentTraceContext;
            this.context = this.parent != null && !this.parent.equals(ctx.getOrDefault(TraceContext.class, null)) ? ctx.put(TraceContext.class, (Object)this.parent) : ctx;
            this.set(clientSpan);
        }

        public void onSubscribe(Subscription subscription) {
            this.actual.onSubscribe((Subscription)new TraceWebClientSubscription(subscription, this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(ClientResponse response) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.parent);){
                if (log.isTraceEnabled()) {
                    log.trace((Object)"OnNext");
                }
                this.actual.onNext((Object)response);
            }
            finally {
                Span span = this.getAndSet(null);
                if (span != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"OnNext finally");
                    }
                    this.handler.handleReceive((HttpClientResponse)new ClientResponseWrapper(response), span);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(Throwable t) {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.parent);){
                if (log.isTraceEnabled()) {
                    log.trace((Object)"OnError");
                }
                this.actual.onError(t);
            }
            finally {
                Span span = this.getAndSet(null);
                if (span != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"OnError finally");
                    }
                    span.error(t);
                    span.end();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(this.parent);){
                if (log.isTraceEnabled()) {
                    log.trace((Object)"OnComplete");
                }
                this.actual.onComplete();
            }
            finally {
                Span span = this.getAndSet(null);
                if (span != null) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Reached OnComplete without finishing [" + span + "]"));
                    }
                    span.abandon();
                }
            }
        }

        public Context currentContext() {
            return this.context;
        }

        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return null;
        }
    }

    private static final class MonoWebClientTrace
    extends Mono<ClientResponse>
    implements Scannable,
    TraceContextPropagator {
        final ExchangeFunction next;
        final ClientRequest request;
        final HttpClientHandler handler;
        final CurrentTraceContext currentTraceContext;

        MonoWebClientTrace(ExchangeFunction next, ClientRequest request, TraceExchangeFilterFunction filterFunction) {
            this.next = next;
            this.request = request;
            this.handler = filterFunction.handler();
            this.currentTraceContext = filterFunction.currentTraceContext();
        }

        public void subscribe(CoreSubscriber<? super ClientResponse> subscriber) {
            TraceContext parent;
            Context context = subscriber.currentContext();
            if (log.isTraceEnabled()) {
                log.trace((Object)("Got the following context [" + context + "]"));
            }
            ClientRequestWrapper wrapper = new ClientRequestWrapper(this.request);
            TraceContext traceContext = parent = context.hasKey(TraceContext.class) ? (TraceContext)context.get(TraceContext.class) : null;
            if (parent == null) {
                parent = this.currentTraceContext.context();
            }
            Span span = this.handler.handleSend((HttpClientRequest)wrapper, parent);
            if (log.isTraceEnabled()) {
                log.trace((Object)("HttpClientHandler::handleSend: " + span));
            }
            this.next.exchange(wrapper.buildRequest()).subscribe((CoreSubscriber)new TraceWebClientSubscriber(subscriber, context, span, parent, this));
        }

        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return null;
        }
    }
}

