/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.internal.SpanNameUtil;
import org.springframework.util.ReflectionUtils;

@Aspect
public class TraceMessagingAspect {
    private static final Log log = LogFactory.getLog(TraceMessagingAspect.class);
    static final String MESSAGING_CONTROLLER_CLASS_KEY = "messaging.controller.class";
    static final String MESSAGING_CONTROLLER_METHOD_KEY = "messaging.controller.method";
    private final Tracer tracer;
    private final SpanNamer spanNamer;

    public TraceMessagingAspect(Tracer tracer, SpanNamer spanNamer) {
        this.tracer = tracer;
        this.spanNamer = spanNamer;
    }

    @Pointcut(value="@annotation(org.springframework.messaging.handler.annotation.MessageMapping)")
    private void anyMessageMappingAnnotated() {
    }

    @Around(value="anyMessageMappingAnnotated()")
    public Object addTags(ProceedingJoinPoint pjp) throws Throwable {
        Object object = pjp.proceed();
        String methodName = pjp.getSignature().getName();
        String className = pjp.getTarget().getClass().getName();
        Span currentSpan = this.currentSpan(pjp);
        currentSpan.tag(MESSAGING_CONTROLLER_CLASS_KEY, className);
        currentSpan.tag(MESSAGING_CONTROLLER_METHOD_KEY, methodName);
        return object;
    }

    private Span currentSpan(ProceedingJoinPoint pjp) {
        Span currentSpan = this.tracer.currentSpan();
        if (currentSpan == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No span found - will create a new one");
            }
            currentSpan = this.tracer.nextSpan().name(this.name(pjp)).start();
        }
        return currentSpan;
    }

    private String name(ProceedingJoinPoint pjp) {
        return this.spanNamer.name((Object)this.getMethod(pjp, pjp.getTarget()), SpanNameUtil.toLowerHyphen(pjp.getSignature().getName()));
    }

    private Method getMethod(ProceedingJoinPoint pjp, Object object) {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        return ReflectionUtils.findMethod(object.getClass(), (String)method.getName(), (Class[])method.getParameterTypes());
    }
}

