/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.kafka;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.kafka.KafkaTracingUtils;
import org.springframework.cloud.sleuth.instrument.kafka.SleuthKafkaSpan;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;

public class TracingKafkaConsumer<K, V>
implements Consumer<K, V> {
    private final BeanFactory beanFactory;
    private final Consumer<K, V> delegate;
    private Propagator propagator;
    private Propagator.Getter<ConsumerRecord<?, ?>> extractor;

    public TracingKafkaConsumer(Consumer<K, V> consumer, BeanFactory beanFactory) {
        this.delegate = consumer;
        this.beanFactory = beanFactory;
    }

    private Propagator propagator() {
        if (this.propagator == null) {
            this.propagator = (Propagator)this.beanFactory.getBean(Propagator.class);
        }
        return this.propagator;
    }

    private Propagator.Getter<ConsumerRecord<?, ?>> extractor() {
        if (this.extractor == null) {
            this.extractor = (Propagator.Getter)this.beanFactory.getBeanProvider(ResolvableType.forClassWithGenerics(Propagator.Getter.class, (ResolvableType[])new ResolvableType[]{ResolvableType.forType((ParameterizedTypeReference)new ParameterizedTypeReference<ConsumerRecord<?, ?>>(){})})).getIfAvailable();
        }
        return this.extractor;
    }

    public Set<TopicPartition> assignment() {
        return this.delegate.assignment();
    }

    public Set<String> subscription() {
        return this.delegate.subscription();
    }

    public void subscribe(Collection<String> collection) {
        this.delegate.subscribe(collection);
    }

    public void subscribe(Collection<String> collection, ConsumerRebalanceListener consumerRebalanceListener) {
        this.delegate.subscribe(collection, consumerRebalanceListener);
    }

    public void assign(Collection<TopicPartition> collection) {
        this.delegate.assign(collection);
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener consumerRebalanceListener) {
        this.delegate.subscribe(pattern, consumerRebalanceListener);
    }

    public void subscribe(Pattern pattern) {
        this.delegate.subscribe(pattern);
    }

    public void unsubscribe() {
        this.delegate.unsubscribe();
    }

    @Deprecated
    public ConsumerRecords<K, V> poll(long l) {
        ConsumerRecords consumerRecords = this.delegate.poll(l);
        for (ConsumerRecord consumerRecord : consumerRecords) {
            KafkaTracingUtils.buildAndFinishSpan(SleuthKafkaSpan.KAFKA_CONSUMER_SPAN, consumerRecord, this.propagator(), this.extractor());
        }
        return consumerRecords;
    }

    public ConsumerRecords<K, V> poll(Duration duration) {
        ConsumerRecords consumerRecords = this.delegate.poll(duration);
        for (ConsumerRecord consumerRecord : consumerRecords) {
            KafkaTracingUtils.buildAndFinishSpan(SleuthKafkaSpan.KAFKA_CONSUMER_SPAN, consumerRecord, this.propagator(), this.extractor());
        }
        return consumerRecords;
    }

    public void commitSync() {
        this.delegate.commitSync();
    }

    public void commitSync(Duration duration) {
        this.delegate.commitSync(duration);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> map) {
        this.delegate.commitSync(map);
    }

    public void commitSync(Map<TopicPartition, OffsetAndMetadata> map, Duration duration) {
        this.delegate.commitSync(map, duration);
    }

    public void commitAsync() {
        this.delegate.commitAsync();
    }

    public void commitAsync(OffsetCommitCallback offsetCommitCallback) {
        this.delegate.commitAsync(offsetCommitCallback);
    }

    public void commitAsync(Map<TopicPartition, OffsetAndMetadata> map, OffsetCommitCallback offsetCommitCallback) {
        this.delegate.commitAsync(map, offsetCommitCallback);
    }

    public void seek(TopicPartition topicPartition, long l) {
        this.delegate.seek(topicPartition, l);
    }

    public void seek(TopicPartition topicPartition, OffsetAndMetadata offsetAndMetadata) {
        this.delegate.seek(topicPartition, offsetAndMetadata);
    }

    public void seekToBeginning(Collection<TopicPartition> collection) {
        this.delegate.seekToBeginning(collection);
    }

    public void seekToEnd(Collection<TopicPartition> collection) {
        this.delegate.seekToEnd(collection);
    }

    public long position(TopicPartition topicPartition) {
        return this.delegate.position(topicPartition);
    }

    public long position(TopicPartition topicPartition, Duration duration) {
        return this.delegate.position(topicPartition, duration);
    }

    @Deprecated
    public OffsetAndMetadata committed(TopicPartition topicPartition) {
        return this.delegate.committed(topicPartition);
    }

    @Deprecated
    public OffsetAndMetadata committed(TopicPartition topicPartition, Duration duration) {
        return this.delegate.committed(topicPartition, duration);
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> set) {
        return this.delegate.committed(set);
    }

    public Map<TopicPartition, OffsetAndMetadata> committed(Set<TopicPartition> set, Duration duration) {
        return this.delegate.committed(set, duration);
    }

    public Map<MetricName, ? extends Metric> metrics() {
        return this.delegate.metrics();
    }

    public List<PartitionInfo> partitionsFor(String s) {
        return this.delegate.partitionsFor(s);
    }

    public List<PartitionInfo> partitionsFor(String s, Duration duration) {
        return this.delegate.partitionsFor(s, duration);
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return this.delegate.listTopics();
    }

    public Map<String, List<PartitionInfo>> listTopics(Duration duration) {
        return this.delegate.listTopics(duration);
    }

    public Set<TopicPartition> paused() {
        return this.delegate.paused();
    }

    public void pause(Collection<TopicPartition> collection) {
        this.delegate.pause(collection);
    }

    public void resume(Collection<TopicPartition> collection) {
        this.delegate.resume(collection);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> map) {
        return this.delegate.offsetsForTimes(map);
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> map, Duration duration) {
        return this.delegate.offsetsForTimes(map, duration);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> collection) {
        return this.delegate.beginningOffsets(collection);
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection<TopicPartition> collection, Duration duration) {
        return this.delegate.beginningOffsets(collection, duration);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> collection) {
        return this.delegate.endOffsets(collection);
    }

    public Map<TopicPartition, Long> endOffsets(Collection<TopicPartition> collection, Duration duration) {
        return this.delegate.endOffsets(collection, duration);
    }

    public ConsumerGroupMetadata groupMetadata() {
        return this.delegate.groupMetadata();
    }

    public void enforceRebalance() {
        this.delegate.enforceRebalance();
    }

    public void close() {
        this.delegate.close();
    }

    public void close(Duration duration) {
        this.delegate.close(duration);
    }

    public void wakeup() {
        this.delegate.wakeup();
    }

    public OptionalLong currentLag(TopicPartition topicPartition) {
        return this.delegate.currentLag(topicPartition);
    }
}

