/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.cloud.sleuth.instrument.async.TraceableExecutorService;
import org.springframework.cloud.sleuth.internal.ContextUtil;

public class TraceableScheduledExecutorService
extends TraceableExecutorService
implements ScheduledExecutorService {
    private static final Map<ExecutorService, TraceableScheduledExecutorService> CACHE = new ConcurrentHashMap<ExecutorService, TraceableScheduledExecutorService>();

    public TraceableScheduledExecutorService(BeanFactory beanFactory, ExecutorService delegate) {
        super(beanFactory, delegate);
    }

    public TraceableScheduledExecutorService(BeanFactory beanFactory, ExecutorService delegate, String beanName) {
        super(beanFactory, delegate, beanName);
    }

    public static TraceableScheduledExecutorService wrap(BeanFactory beanFactory, ExecutorService delegate, String beanName) {
        return CACHE.computeIfAbsent(delegate, e -> new TraceableScheduledExecutorService(beanFactory, delegate, beanName));
    }

    public static TraceableScheduledExecutorService wrap(BeanFactory beanFactory, ExecutorService delegate) {
        return CACHE.computeIfAbsent(delegate, e -> new TraceableScheduledExecutorService(beanFactory, delegate, null));
    }

    private ScheduledExecutorService getScheduledExecutorService() {
        return (ScheduledExecutorService)this.delegate;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.getScheduledExecutorService().schedule(ContextUtil.isContextUnusable(this.beanFactory) ? command : new TraceRunnable(this.tracer(), this.spanNamer(), command, this.spanName), delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.getScheduledExecutorService().schedule(ContextUtil.isContextUnusable(this.beanFactory) ? callable : new TraceCallable(this.tracer(), this.spanNamer(), callable, this.spanName), delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.getScheduledExecutorService().scheduleAtFixedRate(ContextUtil.isContextUnusable(this.beanFactory) ? command : new TraceRunnable(this.tracer(), this.spanNamer(), command, this.spanName), initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.getScheduledExecutorService().scheduleWithFixedDelay(ContextUtil.isContextUnusable(this.beanFactory) ? command : new TraceRunnable(this.tracer(), this.spanNamer(), command, this.spanName), initialDelay, delay, unit);
    }
}

