/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanCustomizer;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.messaging.MessageSpanCustomizer;
import org.springframework.cloud.sleuth.instrument.messaging.SleuthMessagingSpan;
import org.springframework.cloud.sleuth.internal.SpanNameUtil;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.ClassUtils;

public class DefaultMessageSpanCustomizer
implements MessageSpanCustomizer {
    private final boolean integrationObjectSupportPresent = ClassUtils.isPresent((String)"org.springframework.integration.context.IntegrationObjectSupport", null);

    protected String channelName(MessageChannel channel) {
        String name = null;
        if (this.integrationObjectSupportPresent) {
            if (channel instanceof IntegrationObjectSupport) {
                name = ((IntegrationObjectSupport)channel).getComponentName();
            }
            if (name == null && channel instanceof AbstractMessageChannel) {
                name = ((AbstractMessageChannel)channel).getFullChannelName();
            }
        }
        if (name == null) {
            return channel.toString();
        }
        return name;
    }

    private String messageChannelName(MessageChannel channel) {
        return SpanNameUtil.shorten(this.channelName(channel));
    }

    @Override
    public Span customizeHandle(Span spanCustomizer, Message<?> message, @Nullable MessageChannel messageChannel) {
        spanCustomizer.name("handle");
        this.addTags((SpanCustomizer)spanCustomizer, messageChannel);
        return spanCustomizer;
    }

    @Override
    public Span.Builder customizeHandle(Span.Builder spanCustomizer, Message<?> message, @Nullable MessageChannel messageChannel) {
        spanCustomizer.name("handle");
        this.addTags(spanCustomizer, messageChannel);
        return spanCustomizer;
    }

    @Override
    public Span.Builder customizeReceive(Span.Builder spanCustomizer, Message<?> message, @Nullable MessageChannel messageChannel) {
        spanCustomizer.name("receive");
        this.addTags(spanCustomizer, messageChannel);
        return spanCustomizer;
    }

    @Override
    public Span.Builder customizeSend(Span.Builder spanCustomizer, Message<?> message, @Nullable MessageChannel messageChannel) {
        spanCustomizer.name("send");
        this.addTags(spanCustomizer, messageChannel);
        return spanCustomizer;
    }

    private void addTags(SpanCustomizer result, MessageChannel channel) {
        if (channel != null) {
            SleuthMessagingSpan.MESSAGING_SPAN.wrap(result).tag((TagKey)SleuthMessagingSpan.Tags.CHANNEL, this.messageChannelName(channel));
        }
    }

    private void addTags(Span.Builder result, MessageChannel channel) {
        if (channel != null) {
            SleuthMessagingSpan.MESSAGING_SPAN.wrap(result).tag((TagKey)SleuthMessagingSpan.Tags.CHANNEL, this.messageChannelName(channel));
        }
    }
}

