/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.servlet;

import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.cloud.sleuth.http.HttpServerResponse;
import org.springframework.cloud.sleuth.instrument.web.servlet.HttpServletResponseWrapper;

abstract class ServletRuntime {
    private static final ServletRuntime SERVLET_RUNTIME = ServletRuntime.findServletRuntime();

    public HttpServletResponse httpServletResponse(ServletResponse response) {
        return (HttpServletResponse)response;
    }

    public abstract int status(HttpServletResponse var1);

    public abstract boolean isAsync(HttpServletRequest var1);

    public abstract void handleAsync(HttpServerHandler var1, HttpServletRequest var2, HttpServletResponse var3, Span var4);

    ServletRuntime() {
    }

    public static ServletRuntime get() {
        return SERVLET_RUNTIME;
    }

    private static ServletRuntime findServletRuntime() {
        try {
            Class.forName("javax.servlet.AsyncEvent");
            HttpServletRequest.class.getMethod("isAsyncStarted", new Class[0]);
            return new Servlet3();
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new UnsupportedOperationException("Unsupported Servlet type");
    }

    public static void propagateIfFatal(Throwable t) {
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof LinkageError) {
            throw (LinkageError)t;
        }
    }

    static final class Servlet3
    extends ServletRuntime {
        Servlet3() {
        }

        @Override
        public boolean isAsync(HttpServletRequest request) {
            return request.isAsyncStarted();
        }

        @Override
        public int status(HttpServletResponse response) {
            return response.getStatus();
        }

        @Override
        public void handleAsync(HttpServerHandler handler, HttpServletRequest request, HttpServletResponse response, Span span) {
            if (span.isNoop()) {
                return;
            }
            TracingAsyncListener listener = new TracingAsyncListener(handler, span);
            request.getAsyncContext().addListener((AsyncListener)listener, (ServletRequest)request, (ServletResponse)response);
        }

        static final class TracingAsyncListener
        implements AsyncListener {
            final HttpServerHandler handler;
            final Span span;

            TracingAsyncListener(HttpServerHandler handler, Span span) {
                this.handler = handler;
                this.span = span;
            }

            public void onComplete(AsyncEvent e) {
                HttpServletRequest req = (HttpServletRequest)e.getSuppliedRequest();
                Object sendHandled = req.getAttribute("org.springframework.cloud.sleuth.instrument.web.servlet.TracingFilter$SendHandled");
                if (sendHandled instanceof AtomicBoolean && ((AtomicBoolean)sendHandled).compareAndSet(false, true)) {
                    HttpServletResponse res = (HttpServletResponse)e.getSuppliedResponse();
                    HttpServerResponse response = HttpServletResponseWrapper.create(req, res, e.getThrowable());
                    this.handler.handleSend(response, this.span);
                }
            }

            public void onTimeout(AsyncEvent e) {
                ServletRequest request = e.getSuppliedRequest();
                if (request.getAttribute("error") == null) {
                    request.setAttribute("error", (Object)new AsyncTimeoutException(e));
                }
            }

            public void onError(AsyncEvent e) {
                ServletRequest request = e.getSuppliedRequest();
                if (request.getAttribute("error") == null) {
                    request.setAttribute("error", (Object)e.getThrowable());
                }
            }

            public void onStartAsync(AsyncEvent e) {
                AsyncContext eventAsyncContext = e.getAsyncContext();
                if (eventAsyncContext != null) {
                    eventAsyncContext.addListener((AsyncListener)this, e.getSuppliedRequest(), e.getSuppliedResponse());
                }
            }

            public String toString() {
                return "TracingAsyncListener{" + this.span + "}";
            }
        }

        static final class AsyncTimeoutException
        extends TimeoutException {
            AsyncTimeoutException(AsyncEvent e) {
                super("Timed out after " + e.getAsyncContext().getTimeout() + "ms");
            }

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        }
    }
}

