/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.stream;

import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.stream.Host;
import org.springframework.cloud.sleuth.stream.HostLocator;
import org.springframework.context.event.EventListener;
import org.springframework.util.Assert;

public class ServerPropertiesHostLocator
implements HostLocator {
    private final ServerProperties serverProperties;
    private final String appName;
    private Integer port;

    public ServerPropertiesHostLocator(ServerProperties serverProperties, String appName) {
        this.serverProperties = serverProperties;
        this.appName = appName;
        Assert.notNull((Object)this.appName, (String)"appName");
    }

    @Override
    public Host locate(Span span) {
        String serviceName = this.getServiceName(span);
        String address = this.getAddress();
        Integer port = this.getPort();
        return new Host(serviceName, address, port);
    }

    @EventListener(value={EmbeddedServletContainerInitializedEvent.class})
    public void grabPort(EmbeddedServletContainerInitializedEvent event) {
        this.port = event.getEmbeddedServletContainer().getPort();
    }

    private Integer getPort() {
        if (this.port != null) {
            return this.port;
        }
        Integer port = this.serverProperties != null && this.serverProperties.getPort() != null ? this.serverProperties.getPort() : Integer.valueOf(8080);
        return port;
    }

    private String getAddress() {
        String address = this.serverProperties != null && this.serverProperties.getAddress() != null ? this.serverProperties.getAddress().getHostAddress() : "127.0.0.1";
        return address;
    }

    private String getServiceName(Span span) {
        String serviceName = span.getProcessId() != null ? span.getProcessId() : this.appName;
        return serviceName;
    }
}

