/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.stream;

import java.net.InetAddress;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.stream.Host;
import org.springframework.cloud.sleuth.stream.HostLocator;
import org.springframework.cloud.sleuth.stream.ZipkinProperties;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ServiceInstanceHostLocator
implements HostLocator {
    private final ServiceInstance localServiceInstance;
    private final ZipkinProperties zipkinProperties;

    public ServiceInstanceHostLocator(ServiceInstance localServiceInstance, ZipkinProperties zipkinProperties) {
        Assert.notNull((Object)localServiceInstance, (String)"localServiceInstance");
        this.localServiceInstance = localServiceInstance;
        this.zipkinProperties = zipkinProperties;
    }

    @Override
    public Host locate(Span span) {
        String serviceId = StringUtils.hasText((String)this.zipkinProperties.getService().getName()) ? this.zipkinProperties.getService().getName() : this.localServiceInstance.getServiceId();
        return new Host(serviceId, this.getIpAddress(this.localServiceInstance), this.localServiceInstance.getPort());
    }

    private String getIpAddress(ServiceInstance instance) {
        try {
            InetAddress address = InetAddress.getByName(instance.getHost());
            return address.getHostAddress();
        }
        catch (Exception e) {
            return "0.0.0.0";
        }
    }
}

