/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.stream;

import java.lang.invoke.MethodHandles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.servlet.context.ServletWebServerInitializedEvent;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.stream.Host;
import org.springframework.cloud.sleuth.stream.HostLocator;
import org.springframework.cloud.sleuth.stream.ZipkinProperties;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class ServerPropertiesHostLocator
implements HostLocator {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final String IP_ADDRESS_PROP_NAME = "spring.cloud.client.ipAddress";
    private final ServerProperties serverProperties;
    private final InetUtils inetUtils;
    private final ZipkinProperties zipkinProperties;
    private final Environment environment;
    private Integer port;

    public ServerPropertiesHostLocator(ServerProperties serverProperties, Environment environment, ZipkinProperties zipkinProperties, InetUtils inetUtils) {
        this.serverProperties = serverProperties;
        this.environment = environment;
        this.zipkinProperties = zipkinProperties;
        this.inetUtils = inetUtils == null ? new InetUtils(new InetUtilsProperties()) : inetUtils;
    }

    @Override
    public Host locate(Span span) {
        String serviceName = this.getServiceName(span);
        String address = this.getAddress();
        Integer port = this.getPort();
        return new Host(serviceName, address, port);
    }

    @EventListener(value={ServletWebServerInitializedEvent.class})
    public void onApplicationEvent(ServletWebServerInitializedEvent event) {
        this.port = event.getSource().getPort();
    }

    private Integer getPort() {
        if (this.port != null) {
            return this.port;
        }
        Integer port = this.serverProperties != null && this.serverProperties.getPort() != null && this.serverProperties.getPort() > 0 ? this.serverProperties.getPort() : Integer.valueOf(8080);
        return port;
    }

    private String getAddress() {
        String address = this.serverProperties != null && this.serverProperties.getAddress() != null ? this.serverProperties.getAddress().getHostAddress() : (this.environment != null && StringUtils.hasText((String)((String)this.environment.getProperty(IP_ADDRESS_PROP_NAME, String.class))) ? (String)this.environment.getProperty(IP_ADDRESS_PROP_NAME, String.class) : this.inetUtils.findFirstNonLoopbackAddress().getHostAddress());
        return address;
    }

    private String getServiceName(Span span) {
        String serviceName = StringUtils.hasText((String)this.zipkinProperties.getService().getName()) ? this.zipkinProperties.getService().getName() : (span.getProcessId() != null ? span.getProcessId() : this.environment.getProperty("spring.application.name", "unknown"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Span will contain serviceName [" + serviceName + "]"));
        }
        return serviceName;
    }
}

