/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.BDDAssertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.TraceAsyncListenableTaskExecutor;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.cloud.sleuth.test.TestTracingAwareSupplier;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;

public abstract class TraceAsyncListenableTaskExecutorTest
implements TestTracingAwareSupplier {
    AsyncListenableTaskExecutor delegate = new SimpleAsyncTaskExecutor();
    TraceAsyncListenableTaskExecutor traceAsyncListenableTaskExecutor = new TraceAsyncListenableTaskExecutor(this.delegate, this.tracerTest().tracing().tracer(), (SpanNamer)new DefaultSpanNamer());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_listenable_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceAsyncListenableTaskExecutor.submitListenable(this.aRunnable(executed)).get();
        }
        finally {
            span.end();
        }
        BDDAssertions.then((boolean)executed.get()).isTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_listenable_trace_callable() throws Exception {
        Span spanFromListenable;
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            spanFromListenable = (Span)this.traceAsyncListenableTaskExecutor.submitListenable(this.aCallable()).get();
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Object)spanFromListenable).isNotNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_execute_a_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceAsyncListenableTaskExecutor.execute(this.aRunnable(executed));
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_execute_with_timeout_a_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceAsyncListenableTaskExecutor.execute(this.aRunnable(executed), 1L);
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_trace_callable() throws Exception {
        Span spanFromListenable;
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            spanFromListenable = (Span)this.traceAsyncListenableTaskExecutor.submit(this.aCallable()).get();
        }
        finally {
            span.end();
        }
        BDDAssertions.then((Object)spanFromListenable).isNotNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_submit_trace_runnable() throws Exception {
        AtomicBoolean executed = new AtomicBoolean();
        Span span = this.tracerTest().tracing().tracer().nextSpan().name("foo");
        try (Tracer.SpanInScope ws = this.tracerTest().tracing().tracer().withSpan(span.start());){
            this.traceAsyncListenableTaskExecutor.submit(this.aRunnable(executed)).get();
        }
        finally {
            span.end();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> BDDAssertions.then((boolean)executed.get()).isTrue());
    }

    Runnable aRunnable(AtomicBoolean executed) {
        return () -> {
            BDDAssertions.then((Object)this.tracerTest().tracing().tracer().currentSpan()).isNotNull();
            executed.set(true);
        };
    }

    Callable<Span> aCallable() {
        return () -> this.tracerTest().tracing().tracer().currentSpan();
    }
}

