/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.batch;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.assertj.core.api.BDDAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(classes={TestConfig.class})
public abstract class BatchIntegrationTests {
    private static final Log log = LogFactory.getLog(BatchIntegrationTests.class);
    @Autowired
    TestSpanHandler spans;
    @Autowired
    Tracer tracer;
    @Autowired
    StepBuilderFactory stepBuilderFactory;
    @Autowired
    JobBuilderFactory jobBuilderFactory;
    @Autowired
    JobLauncher jobLauncher;

    @BeforeEach
    public void setup() {
        this.spans.clear();
    }

    @Test
    public void should_pass_tracing_information_when_using_batch() throws Exception {
        AtomicReference spanFromTasklet = new AtomicReference();
        Job job = this.jobBuilderFactory.get("myJob").start((Step)this.stepBuilderFactory.get("myTask").tasklet((stepContribution, chunkContext) -> {
            log.info((Object)"Hello");
            spanFromTasklet.set(this.tracer.currentSpan());
            return RepeatStatus.FINISHED;
        }).build()).build();
        JobExecution jobExecution = this.jobLauncher.run(job, new JobParameters());
        BDDAssertions.then((String)jobExecution.getExitStatus().getExitCode()).isEqualTo(ExitStatus.COMPLETED.getExitCode());
        BDDAssertions.then((Object)((Span)spanFromTasklet.get())).isNotNull();
        List<FinishedSpan> spans = this.spans.reportedSpans();
        BDDAssertions.then(spans).hasSize(2);
        BDDAssertions.then((Collection)spans.stream().map(FinishedSpan::getTraceId).collect(Collectors.toSet())).hasSize(1);
        BDDAssertions.then((String)spans.get(0).getName()).isEqualTo("myTask");
        BDDAssertions.then((String)spans.get(1).getName()).isEqualTo("myJob");
        BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
    }

    @Configuration(proxyBeanMethods=false)
    @EnableAutoConfiguration
    @EnableBatchProcessing
    public static class TestConfig {
    }
}

