/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.security;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.BDDAssertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.ListeningSecurityContextHolderStrategy;
import org.springframework.security.core.context.SecurityContextChangedListener;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@ContextConfiguration(classes={Config.class})
public abstract class SpringSecurityTests {
    @Autowired
    TestSpanHandler testSpanHandler;
    @Autowired
    TestRestTemplate restTemplate;

    @BeforeEach
    void setUp() {
        this.testSpanHandler.clear();
    }

    @Test
    void authenticated_user_should_trigger_events() {
        ResponseEntity entity = this.restTemplate.withBasicAuth("user", "password").getForEntity("/", String.class, new Object[0]);
        BDDAssertions.then((boolean)entity.getStatusCode().is2xxSuccessful()).isTrue();
        BDDAssertions.then((String)((String)entity.getBody())).isEqualTo("authenticated");
        Awaitility.await().atMost(Duration.ofSeconds(1L)).untilAsserted(() -> BDDAssertions.then((Iterable)this.testSpanHandler).isNotEmpty());
        List<Map.Entry<Long, String>> authEvents = this.getAuthEvents(this.testSpanHandler.reportedSpans());
        BDDAssertions.then(authEvents).isNotEmpty();
        for (int i = 0; i < authEvents.size(); i += 2) {
            String setEvent = authEvents.get(i).getValue();
            BDDAssertions.then((String)setEvent).isEqualTo("Authentication set UsernamePasswordAuthenticationToken[USER]");
            String clearEvent = authEvents.get(i + 1).getValue();
            BDDAssertions.then((String)clearEvent).isEqualTo("Authentication cleared UsernamePasswordAuthenticationToken[USER]");
        }
    }

    @Test
    void anonymous_user_should_trigger_events() {
        ResponseEntity entity = this.restTemplate.getForEntity("/", String.class, new Object[0]);
        BDDAssertions.then((boolean)entity.getStatusCode().is2xxSuccessful()).isTrue();
        BDDAssertions.then((String)((String)entity.getBody())).contains(new CharSequence[]{"html", "form"});
        Awaitility.await().atMost(Duration.ofSeconds(1L)).untilAsserted(() -> BDDAssertions.then((Iterable)this.testSpanHandler).isNotEmpty());
        List<Map.Entry<Long, String>> authEvents = this.getAuthEvents(this.testSpanHandler.reportedSpans());
        BDDAssertions.then(authEvents).isNotEmpty();
        for (int i = 0; i < authEvents.size(); i += 2) {
            String setEvent = authEvents.get(i).getValue();
            BDDAssertions.then((String)setEvent).isEqualTo("Authentication set AnonymousAuthenticationToken[ROLE_ANONYMOUS]");
            String clearEvent = authEvents.get(i + 1).getValue();
            BDDAssertions.then((String)clearEvent).isEqualTo("Authentication cleared AnonymousAuthenticationToken[ROLE_ANONYMOUS]");
        }
    }

    private List<Map.Entry<Long, String>> getAuthEvents(List<FinishedSpan> spans) {
        return spans.stream().filter(span -> span.getKind() == Span.Kind.SERVER).map(FinishedSpan::getEvents).flatMap(Collection::stream).filter(event -> ((String)event.getValue()).contains("Authentication")).collect(Collectors.toList());
    }

    @RestController
    static class HomeController {
        HomeController() {
        }

        @GetMapping
        String home() {
            return "authenticated";
        }
    }

    @EnableAutoConfiguration(excludeName={"org.springframework.cloud.sleuth.autoconfig.instrument.web.client.TraceWebClientAutoConfiguration"})
    @Configuration(proxyBeanMethods=false)
    static class Config {
        Config(List<SecurityContextChangedListener> listeners) {
            ListeningSecurityContextHolderStrategy strategy = new ListeningSecurityContextHolderStrategy(SecurityContextHolder.getContextHolderStrategy(), listeners);
            SecurityContextHolder.setContextHolderStrategy((SecurityContextHolderStrategy)strategy);
        }

        @Bean
        UserDetailsService userDetailsService() {
            return new InMemoryUserDetailsManager(new UserDetails[]{User.withDefaultPasswordEncoder().username("user").password("password").authorities(new String[]{"USER"}).build()});
        }

        @Bean
        HomeController homeController() {
            return new HomeController();
        }
    }
}

