/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import org.assertj.core.api.BDDAssertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.test.TestSpanHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@ContextConfiguration(classes={TestConfig.class})
@TestPropertySource(properties={"management.endpoints.web.exposure.include:*", "server.servlet.context-path:/context-path", "spring.sleuth.web.ignoreAutoConfiguredSkipPatterns:true"})
public abstract class IgnoreAutoConfiguredSkipPatternsIntegrationTests {
    @Autowired
    TestSpanHandler spans;
    @Autowired
    Tracer tracer;
    @LocalServerPort
    int port;

    @BeforeEach
    @AfterEach
    public void clearSpans() {
        this.spans.clear();
        this.tracer.withSpan(null);
    }

    @Test
    public void should_sample_actuator_endpoint_when_override_pattern_is_true() {
        new RestTemplate().getForObject("http://localhost:" + this.port + "/context-path/actuator/health", String.class, new Object[0]);
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
        });
    }

    @Test
    public void should_sample_non_actuator_endpoint_when_override_pattern_is_true() {
        new RestTemplate().getForObject("http://localhost:" + this.port + "/context-path/something", String.class, new Object[0]);
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
            BDDAssertions.then((Iterable)this.spans).hasSize(1);
        });
    }

    @Test
    public void should_not_sample_default_skip_patterns_when_override_pattern_is_true() {
        new RestTemplate().getForObject("http://localhost:" + this.port + "/context-path/index.html", String.class, new Object[0]);
        Awaitility.await().untilAsserted(() -> {
            BDDAssertions.then((Object)this.tracer.currentSpan()).isNull();
            BDDAssertions.then((Iterable)this.spans).hasSize(0);
        });
    }

    @RestController
    public static class TestRestController {
        @GetMapping(value={"something"})
        void doNothing() {
        }

        @GetMapping(value={"index.html"})
        void html() {
        }
    }

    @EnableAutoConfiguration
    @Configuration(proxyBeanMethods=false)
    public static class TestConfig {
        @Bean
        TestRestController testRestController() {
            return new TestRestController();
        }
    }
}

