/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin.stream;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.cloud.sleuth.Log;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.stream.Spans;
import org.springframework.cloud.sleuth.zipkin.stream.ConvertToZipkinSpanList;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.integration.annotation.MessageEndpoint;
import org.springframework.integration.annotation.ServiceActivator;
import zipkin.Annotation;
import zipkin.BinaryAnnotation;
import zipkin.Endpoint;
import zipkin.Span;
import zipkin.collector.Collector;
import zipkin.collector.CollectorMetrics;
import zipkin.collector.CollectorSampler;
import zipkin.storage.Callback;
import zipkin.storage.StorageComponent;

@MessageEndpoint
@Conditional(value={NotSleuthStreamClient.class})
public class ZipkinMessageListener {
    private static final org.apache.commons.logging.Log log = LogFactory.getLog(ZipkinMessageListener.class);
    static final String UNKNOWN_PROCESS_ID = "unknown";
    final Collector collector;

    @Lazy
    @Autowired
    ZipkinMessageListener(StorageComponent storage, CollectorSampler sampler, CollectorMetrics metrics) {
        this.collector = Collector.builder(this.getClass()).storage(storage).sampler(sampler).metrics(metrics.forTransport("stream")).build();
    }

    @ServiceActivator(inputChannel="sleuth")
    public void sink(Spans input) {
        List<zipkin.Span> converted = ConvertToZipkinSpanList.convert(input);
        this.collector.accept(converted, Callback.NOOP);
    }

    static void addZipkinAnnotations(Span.Builder zipkinSpan, Span span, Endpoint endpoint) {
        for (Log ta : span.logs()) {
            Annotation zipkinAnnotation = Annotation.builder().endpoint(endpoint).timestamp(ta.getTimestamp() * 1000L).value(ta.getEvent()).build();
            zipkinSpan.addAnnotation(zipkinAnnotation);
        }
    }

    static void addZipkinBinaryAnnotations(Span.Builder zipkinSpan, Span span, Endpoint endpoint) {
        for (Map.Entry e : span.tags().entrySet()) {
            BinaryAnnotation.Builder binaryAnn = BinaryAnnotation.builder();
            binaryAnn.type(BinaryAnnotation.Type.STRING);
            binaryAnn.key((String)e.getKey());
            try {
                binaryAnn.value(((String)e.getValue()).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                log.error((Object)"Error encoding string as UTF-8", (Throwable)ex);
            }
            binaryAnn.endpoint(endpoint);
            zipkinSpan.addBinaryAnnotation(binaryAnn.build());
        }
    }

    protected static class NotSleuthStreamClient
    extends SpringBootCondition {
        protected NotSleuthStreamClient() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment environment = context.getEnvironment();
            if ("true".equals(environment.resolvePlaceholders("${spring.sleuth.stream.enabled:}"))) {
                return ConditionOutcome.noMatch((String)"Found spring.sleuth.stream.enabled=true");
            }
            if (environment instanceof ConfigurableEnvironment) {
                ConfigurableEnvironment configurable = (ConfigurableEnvironment)environment;
                configurable.getPropertySources().addLast((PropertySource)new MapPropertySource("spring.sleuth.stream", Collections.singletonMap("spring.sleuth.stream.enabled", "false")));
            }
            return ConditionOutcome.match((String)"Not found: spring.sleuth.stream.enabled");
        }
    }
}

