/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.sleuth.Sampler;
import org.springframework.cloud.sleuth.SpanReporter;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.metric.SpanMetricReporter;
import org.springframework.cloud.sleuth.sampler.PercentageBasedSampler;
import org.springframework.cloud.sleuth.sampler.SamplerProperties;
import org.springframework.cloud.sleuth.zipkin.DiscoveryClientEndpointLocator;
import org.springframework.cloud.sleuth.zipkin.EndpointLocator;
import org.springframework.cloud.sleuth.zipkin.FallbackHavingEndpointLocator;
import org.springframework.cloud.sleuth.zipkin.HttpZipkinSpanReporter;
import org.springframework.cloud.sleuth.zipkin.ServerPropertiesEndpointLocator;
import org.springframework.cloud.sleuth.zipkin.ZipkinProperties;
import org.springframework.cloud.sleuth.zipkin.ZipkinSpanListener;
import org.springframework.cloud.sleuth.zipkin.ZipkinSpanReporter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={ZipkinProperties.class, SamplerProperties.class})
@ConditionalOnProperty(value={"spring.zipkin.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={TraceAutoConfiguration.class})
public class ZipkinAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ZipkinSpanReporter reporter(SpanMetricReporter spanMetricReporter, ZipkinProperties zipkin) {
        return new HttpZipkinSpanReporter(zipkin.getBaseUrl(), zipkin.getFlushInterval(), zipkin.getCompression().isEnabled(), spanMetricReporter);
    }

    @Bean
    @ConditionalOnMissingBean
    public Sampler defaultTraceSampler(SamplerProperties config) {
        return new PercentageBasedSampler(config);
    }

    @Bean
    public SpanReporter zipkinSpanListener(ZipkinSpanReporter reporter, EndpointLocator endpointLocator) {
        return new ZipkinSpanListener(reporter, endpointLocator);
    }

    @Configuration
    @ConditionalOnClass(value={DiscoveryClient.class})
    protected static class DiscoveryClientEndpointLocatorConfiguration {
        @Autowired(required=false)
        private ServerProperties serverProperties;
        @Value(value="${spring.application.name:unknown}")
        private String appName;
        @Autowired(required=false)
        private DiscoveryClient client;

        protected DiscoveryClientEndpointLocatorConfiguration() {
        }

        @Bean
        public EndpointLocator zipkinEndpointLocator() {
            return new FallbackHavingEndpointLocator(this.discoveryClientEndpointLocator(), new ServerPropertiesEndpointLocator(this.serverProperties, this.appName));
        }

        private DiscoveryClientEndpointLocator discoveryClientEndpointLocator() {
            if (this.client != null) {
                return new DiscoveryClientEndpointLocator(this.client);
            }
            return null;
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.cloud.client.discovery.DiscoveryClient"})
    protected static class DefaultEndpointLocatorConfiguration {
        @Autowired(required=false)
        private ServerProperties serverProperties;
        @Value(value="${spring.application.name:unknown}")
        private String appName;

        protected DefaultEndpointLocatorConfiguration() {
        }

        @Bean
        public EndpointLocator zipkinEndpointLocator() {
            return new ServerPropertiesEndpointLocator(this.serverProperties, this.appName);
        }
    }
}

