/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin;

import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.sleuth.zipkin.EndpointLocator;
import zipkin.Endpoint;

public class DiscoveryClientEndpointLocator
implements EndpointLocator {
    private DiscoveryClient client;

    public DiscoveryClientEndpointLocator(DiscoveryClient client) {
        this.client = client;
    }

    @Override
    public Endpoint local() {
        ServiceInstance instance = this.client.getLocalServiceInstance();
        if (instance == null) {
            throw new NoServiceInstanceAvailableException();
        }
        return Endpoint.builder().serviceName(instance.getServiceId()).ipv4(this.getIpAddress(instance)).port(instance.getPort()).build();
    }

    private int getIpAddress(ServiceInstance instance) {
        try {
            return InetUtils.getIpAddressAsInt((String)instance.getHost());
        }
        catch (Exception e) {
            return 0;
        }
    }

    static class NoServiceInstanceAvailableException
    extends RuntimeException {
        NoServiceInstanceAvailableException() {
        }
    }
}

