/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.java;

import javax.sql.DataSource;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.config.java.ServiceConnectionFactory;
import org.springframework.cloud.service.PooledServiceConnectorConfig;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.document.MongoDbFactoryConfig;
import org.springframework.cloud.service.messaging.RabbitConnectionFactoryConfig;
import org.springframework.cloud.service.relational.DataSourceConfig;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;

public class CloudServiceConnectionFactory
implements ServiceConnectionFactory {
    protected final Cloud cloud;

    public CloudServiceConnectionFactory(Cloud cloud) {
        this.cloud = cloud;
    }

    @Override
    public DataSource dataSource() {
        return this.dataSource((DataSourceConfig)null);
    }

    @Override
    public DataSource dataSource(DataSourceConfig dataSourceConfig) {
        return (DataSource)this.cloud.getSingletonServiceConnector(DataSource.class, (ServiceConnectorConfig)dataSourceConfig);
    }

    @Override
    public DataSource dataSource(String serviceId) {
        return this.dataSource(serviceId, null);
    }

    @Override
    public DataSource dataSource(String serviceId, DataSourceConfig dataSourceConfig) {
        return (DataSource)this.cloud.getServiceConnector(serviceId, DataSource.class, (ServiceConnectorConfig)dataSourceConfig);
    }

    @Override
    public MongoDbFactory mongoDbFactory() {
        return this.mongoDbFactory((MongoDbFactoryConfig)null);
    }

    @Override
    public MongoDbFactory mongoDbFactory(MongoDbFactoryConfig mongoDbFactoryConfig) {
        return (MongoDbFactory)this.cloud.getSingletonServiceConnector(MongoDbFactory.class, (ServiceConnectorConfig)mongoDbFactoryConfig);
    }

    @Override
    public MongoDbFactory mongoDbFactory(String serviceId) {
        return this.mongoDbFactory(serviceId, null);
    }

    @Override
    public MongoDbFactory mongoDbFactory(String serviceId, MongoDbFactoryConfig mongoDbFactoryConfig) {
        return (MongoDbFactory)this.cloud.getServiceConnector(serviceId, MongoDbFactory.class, (ServiceConnectorConfig)mongoDbFactoryConfig);
    }

    @Override
    public ConnectionFactory rabbitConnectionFactory() {
        return this.rabbitConnectionFactory((RabbitConnectionFactoryConfig)null);
    }

    @Override
    public ConnectionFactory rabbitConnectionFactory(RabbitConnectionFactoryConfig rabbitConnectionFactoryConfig) {
        return (ConnectionFactory)this.cloud.getSingletonServiceConnector(ConnectionFactory.class, (ServiceConnectorConfig)rabbitConnectionFactoryConfig);
    }

    @Override
    public ConnectionFactory rabbitConnectionFactory(String serviceId) {
        return this.rabbitConnectionFactory(serviceId, null);
    }

    @Override
    public ConnectionFactory rabbitConnectionFactory(String serviceId, RabbitConnectionFactoryConfig rabbitConnectionFactoryConfig) {
        return (ConnectionFactory)this.cloud.getServiceConnector(serviceId, ConnectionFactory.class, (ServiceConnectorConfig)rabbitConnectionFactoryConfig);
    }

    @Override
    public RedisConnectionFactory redisConnectionFactory() {
        return this.redisConnectionFactory((PooledServiceConnectorConfig)null);
    }

    @Override
    public RedisConnectionFactory redisConnectionFactory(PooledServiceConnectorConfig redisConnectionFactoryConfig) {
        return (RedisConnectionFactory)this.cloud.getSingletonServiceConnector(RedisConnectionFactory.class, (ServiceConnectorConfig)redisConnectionFactoryConfig);
    }

    @Override
    public RedisConnectionFactory redisConnectionFactory(String serviceId) {
        return this.redisConnectionFactory(serviceId, null);
    }

    @Override
    public RedisConnectionFactory redisConnectionFactory(String serviceId, PooledServiceConnectorConfig redisConnectionFactoryConfig) {
        return (RedisConnectionFactory)this.cloud.getServiceConnector(serviceId, RedisConnectionFactory.class, (ServiceConnectorConfig)redisConnectionFactoryConfig);
    }

    @Override
    public Object service() {
        return this.service(Object.class);
    }

    @Override
    public <T> T service(Class<T> serviceConnectorType) {
        return (T)this.cloud.getSingletonServiceConnector(serviceConnectorType, null);
    }

    @Override
    public Object service(String serviceId) {
        return this.service(serviceId, Object.class);
    }

    @Override
    public <T> T service(String serviceId, Class<T> serviceConnectorType) {
        return (T)this.cloud.getServiceConnector(serviceId, serviceConnectorType, null);
    }

    @Override
    public <T> T service(String serviceId, Class<T> serviceConnectorType, ServiceConnectorConfig serviceConnectorConfig) {
        return (T)this.cloud.getServiceConnector(serviceId, serviceConnectorType, serviceConnectorConfig);
    }
}

