/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service;

import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.util.StringUtils;

public class PooledServiceConnectorConfig
implements ServiceConnectorConfig {
    private PoolConfig poolConfig;

    public PooledServiceConnectorConfig(PoolConfig poolConfig) {
        this.poolConfig = poolConfig;
    }

    public PoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    public static class PoolConfig {
        private int minPoolSize;
        private int maxPoolSize;
        private int maxWaitTime;

        public PoolConfig(int minPoolSize, int maxPoolSize, int maxWaitTime) {
            this.minPoolSize = minPoolSize;
            this.maxPoolSize = maxPoolSize;
            this.maxWaitTime = maxWaitTime;
        }

        public PoolConfig(int maxPoolSize, int maxWaitTime) {
            this(0, maxPoolSize, maxWaitTime);
        }

        public PoolConfig(String poolSize, int maxWaitTime) {
            this.determinePoolSizeRange(poolSize);
            this.maxWaitTime = maxWaitTime;
        }

        public int getInitialSize() {
            return this.minPoolSize;
        }

        public int getMinIdle() {
            return this.minPoolSize;
        }

        public int getMaxActive() {
            return this.maxPoolSize;
        }

        public int getMaxTotal() {
            return this.maxPoolSize;
        }

        public int getMaxWait() {
            return this.maxWaitTime;
        }

        public int getMaxWaitMillis() {
            return this.maxWaitTime;
        }

        private void determinePoolSizeRange(String poolSize) {
            if (StringUtils.hasText((String)poolSize)) {
                try {
                    int maxPoolSize;
                    int minPoolSize;
                    int separatorIndex = poolSize.indexOf(45);
                    if (separatorIndex != -1) {
                        minPoolSize = Integer.valueOf(poolSize.substring(0, separatorIndex));
                        if (minPoolSize > (maxPoolSize = Integer.valueOf(poolSize.substring(separatorIndex + 1, poolSize.length())).intValue())) {
                            throw new IllegalArgumentException("Lower bound of pool-size range must not exceed the upper bound");
                        }
                    } else {
                        Integer value = Integer.valueOf(poolSize);
                        minPoolSize = 0;
                        maxPoolSize = value;
                    }
                    this.minPoolSize = minPoolSize;
                    this.maxPoolSize = maxPoolSize;
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Invalid pool-size value [" + poolSize + "]: only single " + "maximum integer (e.g. \"5\") and minimum-maximum range (e.g. \"3-5\") are supported", ex);
                }
            }
        }
    }
}

