/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.messaging;

import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.cloud.service.AbstractServiceConnectorCreator;
import org.springframework.cloud.service.ServiceConnectorConfig;
import org.springframework.cloud.service.common.AmqpServiceInfo;
import org.springframework.cloud.service.messaging.RabbitConnectionFactoryConfig;
import org.springframework.cloud.service.messaging.RabbitConnectionFactoryConfigurer;

public class RabbitConnectionFactoryCreator
extends AbstractServiceConnectorCreator<ConnectionFactory, AmqpServiceInfo> {
    private RabbitConnectionFactoryConfigurer configurer = new RabbitConnectionFactoryConfigurer();

    public ConnectionFactory create(AmqpServiceInfo serviceInfo, ServiceConnectorConfig serviceConnectorConfiguration) {
        com.rabbitmq.client.ConnectionFactory connectionFactory = this.createRabbitConnectionFactory(serviceInfo);
        this.configurer.configure(connectionFactory, (RabbitConnectionFactoryConfig)serviceConnectorConfiguration);
        return this.createSpringConnectionFactory(serviceInfo, serviceConnectorConfiguration, connectionFactory);
    }

    private com.rabbitmq.client.ConnectionFactory createRabbitConnectionFactory(AmqpServiceInfo serviceInfo) {
        com.rabbitmq.client.ConnectionFactory connectionFactory = new com.rabbitmq.client.ConnectionFactory();
        if (serviceInfo.getUris() != null && serviceInfo.getUris().size() > 0) {
            this.setConnectionFactoryUri(connectionFactory, (String)serviceInfo.getUris().get(0));
        } else {
            this.setConnectionFactoryUri(connectionFactory, serviceInfo.getUri());
        }
        return connectionFactory;
    }

    private void setConnectionFactoryUri(com.rabbitmq.client.ConnectionFactory connectionFactory, String uri) {
        try {
            connectionFactory.setUri(uri);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid AMQP URI", e);
        }
    }

    private CachingConnectionFactory createSpringConnectionFactory(AmqpServiceInfo serviceInfo, ServiceConnectorConfig serviceConnectorConfiguration, com.rabbitmq.client.ConnectionFactory connectionFactory) {
        Integer channelCacheSize;
        CachingConnectionFactory cachingConnectionFactory = new CachingConnectionFactory(connectionFactory);
        if (serviceInfo.getUris() != null) {
            cachingConnectionFactory.setAddresses(this.getAddresses(serviceInfo));
        }
        if (serviceConnectorConfiguration != null && (channelCacheSize = ((RabbitConnectionFactoryConfig)serviceConnectorConfiguration).getChannelCacheSize()) != null) {
            cachingConnectionFactory.setChannelCacheSize(channelCacheSize.intValue());
        }
        return cachingConnectionFactory;
    }

    private String getAddresses(AmqpServiceInfo serviceInfo) {
        try {
            StringBuilder addresses = new StringBuilder();
            for (String uriString : serviceInfo.getUris()) {
                URI uri = new URI(uriString);
                if (addresses.length() > 0) {
                    addresses.append(',');
                }
                addresses.append(uri.getHost()).append(':').append(uri.getPort());
            }
            return addresses.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid AMQP URI", e);
        }
    }
}

