/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.relational;

import javax.sql.DataSource;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.cloud.service.MapServiceConnectionConfigurer;
import org.springframework.cloud.service.MapServiceConnectorConfig;
import org.springframework.cloud.service.PooledServiceConnectorConfigurer;
import org.springframework.cloud.service.Util;
import org.springframework.cloud.service.relational.DataSourceConfig;

public class DataSourceConfigurer
extends PooledServiceConnectorConfigurer<DataSource, DataSourceConfig> {
    private MapServiceConnectionConfigurer<DataSource, MapServiceConnectorConfig> mapServiceConnectionConfigurer = new MapServiceConnectionConfigurer();

    @Override
    public DataSource configure(DataSource dataSource, DataSourceConfig config) {
        if (config != null) {
            this.configureConnection(dataSource, config);
            this.configureConnectionProperties(dataSource, config);
            return super.configure(dataSource, config);
        }
        return dataSource;
    }

    private void configureConnection(DataSource dataSource, DataSourceConfig config) {
        if (config.getConnectionConfiguration() != null) {
            BeanWrapperImpl target = new BeanWrapperImpl((Object)dataSource);
            BeanWrapperImpl connectionSource = new BeanWrapperImpl((Object)config.getConnectionConfiguration());
            Util.setCorrespondingProperties((BeanWrapper)target, (BeanWrapper)connectionSource);
        }
    }

    private void configureConnectionProperties(DataSource dataSource, DataSourceConfig config) {
        if (config.getConnectionProperties() != null) {
            this.mapServiceConnectionConfigurer.configure(dataSource, config.getConnectionProperties());
        }
    }
}

