/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.service.relational;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

class UrlDecodingDataSource
extends DelegatingDataSource {
    private static final Logger logger = Logger.getLogger(DelegatingDataSource.class.getName());
    private final String urlPropertyName;
    private final Function<String, DataSource> connectionTestDataSourceFactory;
    private volatile boolean successfullyConnected = false;

    UrlDecodingDataSource(String jdbcUrl) {
        this(UrlDecodingDataSource.newSimpleDriverDataSource(jdbcUrl), "url");
    }

    UrlDecodingDataSource(DataSource targetDataSource, String urlPropertyName) {
        this(targetDataSource, urlPropertyName, UrlDecodingDataSource::newSimpleDriverDataSource);
    }

    UrlDecodingDataSource(DataSource targetDataSource, String urlPropertyName, Function<String, DataSource> connectionTestDataSourceFactory) {
        super(targetDataSource);
        this.urlPropertyName = urlPropertyName;
        this.connectionTestDataSourceFactory = connectionTestDataSourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        if (this.successfullyConnected) {
            return super.getConnection();
        }
        UrlDecodingDataSource urlDecodingDataSource = this;
        synchronized (urlDecodingDataSource) {
            Connection connection;
            try {
                connection = super.getConnection();
                this.successfullyConnected = true;
            }
            catch (SQLException e) {
                logger.info("Database connection failed. Trying again with url-decoded jdbc url");
                DataSource targetDataSource = this.getTargetDataSource();
                if (targetDataSource == null) {
                    throw new IllegalStateException("target DataSource should never be null");
                }
                BeanWrapperImpl dataSourceWrapper = new BeanWrapperImpl((Object)targetDataSource);
                String decodedJdbcUrl = UrlDecodingDataSource.decode((String)dataSourceWrapper.getPropertyValue(this.urlPropertyName));
                DataSource urlDecodedConnectionTestDataSource = this.connectionTestDataSourceFactory.apply(decodedJdbcUrl);
                urlDecodedConnectionTestDataSource.getConnection();
                logger.info("Connection test successful. Continuing with url-decoded jdbc url");
                dataSourceWrapper.setPropertyValue(this.urlPropertyName, (Object)decodedJdbcUrl);
                connection = super.getConnection();
                this.successfullyConnected = true;
            }
            return connection;
        }
    }

    private static DataSource newSimpleDriverDataSource(String jdbcUrl) {
        try {
            return new SimpleDriverDataSource(DriverManager.getDriver(jdbcUrl), jdbcUrl);
        }
        catch (SQLException e) {
            throw new RuntimeException("Unable to construct DataSource", e);
        }
    }

    private static String decode(String string) {
        try {
            return URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return string;
        }
    }
}

