/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kstream.config;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.properties.KafkaBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kstream.KStreamBoundElementFactory;
import org.springframework.cloud.stream.binder.kstream.KStreamListenerParameterAdapter;
import org.springframework.cloud.stream.binder.kstream.KStreamListenerSetupMethodOrchestrator;
import org.springframework.cloud.stream.binder.kstream.KStreamStreamListenerResultAdapter;
import org.springframework.cloud.stream.binder.kstream.MessageConversionDelegate;
import org.springframework.cloud.stream.binding.StreamListenerResultAdapter;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.converter.CompositeMessageConverterFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.kafka.annotation.KafkaStreamsDefaultConfiguration;
import org.springframework.kafka.core.StreamsBuilderFactoryBean;
import org.springframework.util.ObjectUtils;

public class KStreamBinderSupportAutoConfiguration {
    @Bean
    @ConfigurationProperties(prefix="spring.cloud.stream.kstream.binder")
    public KafkaBinderConfigurationProperties binderConfigurationProperties() {
        return new KafkaBinderConfigurationProperties();
    }

    @Bean(name={"defaultKafkaStreamsBuilder"})
    public StreamsBuilderFactoryBean defaultKafkaStreamBuilder(@Qualifier(value="defaultKafkaStreamsConfig") ObjectProvider<StreamsConfig> streamsConfigProvider) {
        StreamsConfig streamsConfig = (StreamsConfig)streamsConfigProvider.getIfAvailable();
        if (streamsConfig != null) {
            StreamsBuilderFactoryBean kStreamBuilderFactoryBean = new StreamsBuilderFactoryBean(streamsConfig);
            kStreamBuilderFactoryBean.setPhase(2147483147);
            return kStreamBuilderFactoryBean;
        }
        throw new UnsatisfiedDependencyException(KafkaStreamsDefaultConfiguration.class.getName(), "defaultKafkaStreamsBuilder", "streamsConfig", "There is no 'defaultKafkaStreamsConfig' StreamsConfig bean in the application context.\n");
    }

    @Bean(value={"defaultKafkaStreamsConfig"})
    public StreamsConfig streamsConfig(KafkaBinderConfigurationProperties binderConfigurationProperties) {
        Properties props = new Properties();
        props.put("bootstrap.servers", binderConfigurationProperties.getKafkaConnectionString());
        props.put("default.key.serde", Serdes.ByteArraySerde.class.getName());
        props.put("default.value.serde", Serdes.ByteArraySerde.class.getName());
        props.put("application.id", "default");
        if (!ObjectUtils.isEmpty((Object)binderConfigurationProperties.getConfiguration())) {
            props.putAll((Map<?, ?>)binderConfigurationProperties.getConfiguration());
        }
        return new StreamsConfig((Map)props);
    }

    @Bean
    public KStreamStreamListenerResultAdapter kafkaStreamStreamListenerResultAdapter() {
        return new KStreamStreamListenerResultAdapter();
    }

    @Bean
    public KStreamListenerParameterAdapter kafkaStreamListenerParameterAdapter(MessageConversionDelegate messageConversionDelegate) {
        return new KStreamListenerParameterAdapter(messageConversionDelegate);
    }

    @Bean
    public KStreamListenerSetupMethodOrchestrator kStreamListenerSetupMethodOrchestrator(KStreamListenerParameterAdapter kafkaStreamListenerParameterAdapter, Collection<StreamListenerResultAdapter> streamListenerResultAdapters) {
        return new KStreamListenerSetupMethodOrchestrator(kafkaStreamListenerParameterAdapter, streamListenerResultAdapters);
    }

    @Bean
    public MessageConversionDelegate messageConversionDelegate(BindingServiceProperties bindingServiceProperties, CompositeMessageConverterFactory compositeMessageConverterFactory) {
        return new MessageConversionDelegate(bindingServiceProperties, compositeMessageConverterFactory);
    }

    @Bean
    public KStreamBoundElementFactory kafkaStreamBindableTargetFactory(StreamsBuilder kStreamBuilder, BindingServiceProperties bindingServiceProperties) {
        return new KStreamBoundElementFactory(kStreamBuilder, bindingServiceProperties);
    }
}

