/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kstream.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.stream.binder.ExtendedBindingProperties;
import org.springframework.cloud.stream.binder.kstream.config.KStreamBindingProperties;
import org.springframework.cloud.stream.binder.kstream.config.KStreamConsumerProperties;
import org.springframework.cloud.stream.binder.kstream.config.KStreamProducerProperties;

@ConfigurationProperties(value="spring.cloud.stream.kstream")
public class KStreamExtendedBindingProperties
implements ExtendedBindingProperties<KStreamConsumerProperties, KStreamProducerProperties> {
    private Map<String, KStreamBindingProperties> bindings = new HashMap<String, KStreamBindingProperties>();

    public Map<String, KStreamBindingProperties> getBindings() {
        return this.bindings;
    }

    public void setBindings(Map<String, KStreamBindingProperties> bindings) {
        this.bindings = bindings;
    }

    public KStreamConsumerProperties getExtendedConsumerProperties(String binding) {
        if (this.bindings.containsKey(binding) && this.bindings.get(binding).getConsumer() != null) {
            return this.bindings.get(binding).getConsumer();
        }
        return new KStreamConsumerProperties();
    }

    public KStreamProducerProperties getExtendedProducerProperties(String binding) {
        if (this.bindings.containsKey(binding) && this.bindings.get(binding).getProducer() != null) {
            return this.bindings.get(binding).getProducer();
        }
        return new KStreamProducerProperties();
    }
}

