/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.redis.config;

import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.RedisHealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.cloud.CloudAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.CloudFactory;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.redis.config.RedisMessageChannelBinderConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
@ConditionalOnMissingBean(value={Binder.class})
@Import(value={RedisMessageChannelBinderConfiguration.class})
@PropertySource(value={"classpath:/META-INF/spring-cloud-stream/redis-binder.properties"})
@AutoConfigureBefore(value={CloudAutoConfiguration.class, RedisAutoConfiguration.class})
public class RedisServiceAutoConfiguration {
    @Bean
    public HealthIndicator binderHealthIndicator(RedisConnectionFactory redisConnectionFactory) {
        return new RedisHealthIndicator(redisConnectionFactory);
    }

    @Profile(value={"!cloud"})
    @Import(value={RedisAutoConfiguration.class})
    protected static class NoCloudConfig {
        protected NoCloudConfig() {
        }
    }

    @Configuration
    @ConditionalOnClass(value={Cloud.class})
    @Profile(value={"cloud"})
    protected static class CloudConfig {
        protected CloudConfig() {
        }

        @Bean
        public Cloud cloud() {
            return new CloudFactory().getCloud();
        }

        @Bean
        @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
        RedisConnectionFactory redisConnectionFactory(Cloud cloud) {
            return (RedisConnectionFactory)cloud.getSingletonServiceConnector(RedisConnectionFactory.class, null);
        }
    }
}

